#!/bin/sh
#******************************************************************************#
#    Name of the Script : change_db_archive.sh                                 #
#    Purpose            : This script changes the database from noarchive      #
#                         to archive mode                                      #
#    Created by         : Suresh Neravati                                      #
#    Created on         : 03/21/2013                                           #
#                                                                              #
#******************************************************************************#
#!/bin/sh

ARCH_MODE=$(sqlplus -S /nolog<<SQL1
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT LOG_MODE FROM SYS.V\$DATABASE;
  exit
SQL1
)
if [ "${ARCH_MODE}" = "NOARCHIVELOG" ]; then
  echo -e "\nPlease wait....!, Database is changing to Archive mode.....\n"
sqlplus -S /nolog<<EOFSQL
  connect / as sysdba
  shut immediate
  startup mount
  alter database archivelog;
  alter database open;
  exit
EOFSQL
  echo -e "\nDatabase has changed to archive mode successfully...\n"
elif [ "${ARCH_MODE}" = "ARCHIVELOG" ]; then
  echo -e "\nDatabase is already running in archive mode.\n"
fi
