#!/bin/sh
#******************************************************************************************#
#    Name of the Script : create_rman_backup.sh                                            #
#    Purpose            : This script runs the rman full backup script and shows the       #
#                         status and output location of the backup.                        #
#    Created by         : Suresh Neravati                                                  #
#    Created on         : 03/21/2013                                                       #
#                                                                                          #
#******************************************************************************************#

INSTALL_DIR="/home/oracle/scripts/createbackup"
if [ -f "/home/oracle/.profile" ]; then
  source /home/oracle/.profile
elif [ -f "/home/oracle/.bash_profile" ]; then
  source /home/oracle/.bash_profile
fi

echo "***********************************************"
${INSTALL_DIR}/change_db_archive.sh
/bin/cp /etc/oratab ${INSTALL_DIR}/old_oratab
/bin/cp /etc/oratab ${INSTALL_DIR}/new_oratab
sed -i "/DWT1 */d" ${INSTALL_DIR}/new_oratab
cat ${INSTALL_DIR}/old_oratab | grep "DWT1" | awk '{gsub(":Y",":N") ; print $0}' >> ${INSTALL_DIR}/new_oratab
/bin/cp ${INSTALL_DIR}/new_oratab /etc/oratab 
echo -e "\nStarting RMan Backup, please wait......!\n"
BACKUPDATE=`date '+%Y%m%d'`
RMAN_LOG="/opt/oracle/backup/ttv/full/rman_ttv_${BACKUPDATE}.log"
/opt/oracle/backup/scripts/rman_backup.ksh DISK

if [ ! -f "${RMAN_LOG}" ]; then
  echo -e "RMan backup failed ....!, \n RMan log file ${RMAN_LOG} is missing, please check."
  exit 1
else
  if grep -q "ORA-\|No space left on device\|Permission denied\|SQL-" "${RMAN_LOG}" 
     then
        echo "*********************************************************************"
	echo "RMan backup probably failed! Check ${RMAN_LOG} file for any errors"
        echo *"********************************************************************"
	exit 1
     else
        DTSTAMP=`ls -ldt /opt/oracle/backup/ttv/full/backup* | awk -F / '{print }' | cut -d'_' -f2 | head -1`
        crontab -l >  /opt/oracle/backup/ttv/full/backup_${DTSTAMP}/old_oracle_crontab
        /bin/cp ${INSTALL_DIR}/old_oratab /etc/oratab
        echo    "******************************************************************"
	echo -e "Script completed SUCCESSFULLY and the database backup " 
        echo -e "created at /opt/oracle/backup/ttv/full/backup_${BACKUPDATE}."
        echo -e "******************************************************************\n"
     fi 
fi
exit 0
