##############################################################################################################
##    Script Name    : getUpgradePath.sh                                                                    ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/16/2013                                                                           ##
##    Usage          : ./getUpgradePath.sh                                                                  ##
##    Purpose        : Determine the upgrade path (from version and to version)                             ##
##                       for the current CMS Upgrade.                                                       ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script can be used to determine the upgrade path for the current CMS upgrade. 
## This script assumes that CMS database upgrade has already happened, 
##    and the system_settings table has the correct CMS version before upgrade. 
## Also the environment variables and functions need to have been already initialized
##    by sourcing ./initEnvCommon.sh.
##

me="getUpgradePath.sh"

logMsg "$me invoked with args: $*"

ACTIVITY="getting upgrade path for the current CMS upgrade"

logBeginMsg "$ACTIVITY"

$JAVA -classpath $CLASSPATH com.ericsson.cms.upgrade.UpgradeManager $*

VERSION_BEFORE_FILE_NAME=cmsversionbeforeupgrade.txt
VERSION_BEFORE_FILE_PATH=$TMP_DIRECTORY/$VERSION_BEFORE_FILE_NAME

logMsg "VERSION_BEFORE_FILE_PATH = $VERSION_BEFORE_FILE_PATH"

UPGRADE_PATH_NAME_PREFIX=
UPGRADE_PATH_NAME_SEPARATOR=-
MAIN_UPGRADE_SCRIPT_PREFIX=upgradeCMSMain
MAIN_UPGRADE_SCRIPT_SUFFIX=.sh

cmsVersionBeforeUpgrade=$(cat $VERSION_BEFORE_FILE_PATH)
shortCMSVersionBeforeUpgrade=${cmsVersionBeforeUpgrade:0:3}
upgrade_from_cms_version="${shortCMSVersionBeforeUpgrade//./_}"
upgrade_to_cms_version=$CMS_VERSION_3_1
upgrade_path_name=$UPGRADE_PATH_NAME_PREFIX$upgrade_from_cms_version$UPGRADE_PATH_NAME_SEPARATOR$upgrade_to_cms_version
cms_upgrade_script_name=$MAIN_UPGRADE_SCRIPT_PREFIX$upgrade_path_name$MAIN_UPGRADE_SCRIPT_SUFFIX

export cmsVersionBeforeUpgrade
export shortCMSVersionBeforeUpgrade
export upgrade_from_cms_version
export upgrade_to_cms_version
export upgrade_path_name
export cms_upgrade_script_name

logMsg "cmsVersionBeforeUpgrade = $cmsVersionBeforeUpgrade"
logMsg "shortCMSVersionBeforeUpgrade = $shortCMSVersionBeforeUpgrade"
logMsg "upgrade_from_cms_version = $upgrade_from_cms_version"
logMsg "upgrade_to_cms_version = $upgrade_to_cms_version"
logMsg "upgrade_path_name = $upgrade_path_name"
logMsg "cms_upgrade_script_name = $cms_upgrade_script_name"

logDoneMsg "$ACTIVITY"
