##############################################################################################################
##    Script Name    : initEnvCommon.sh                                                                     ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/22/2013                                                                           ##
##    Usage          : ./initEnvCommon.sh                                                                   ##
##    Purpose        : Script for initializing environment for upgrade of CMS App Server to version 3.1.    ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script initializes several variables and utility functions,  
##       which are used by CMS backup restore (restore-CMS.sh) and CMS Upgrade (upgradeCMSMain.sh). 
##

./activitySeparator.sh

oldme=$me
me="initEnvCommon.sh"

echo "$me invoked with args: $*"

MESSAGE_PREFIX="    $me: "

INIT_ACTIVITY="initializing common environment variables"
INIT_ACTIVITY_MSG="$MESSAGE_PREFIX$INIT_ACTIVITY$MESSAGE_SUFFIX"

echo "$INIT_ACTIVITY_MSG"

INIT_SUB_ACTIVITY="sourcing upgrade utilities script"
INIT_SUB_ACTIVITY_MSG="$MESSAGE_PREFIX$INIT_SUB_ACTIVITY$MESSAGE_SUFFIX"

echo "$INIT_SUB_ACTIVITY_MSG"

. ./upgradeUtils.sh

logDoneMsg "$INIT_SUB_ACTIVITY"

activitySeparator

UPGRADE_HOME=/home/upgrade
SCRIPTS_DIR=$UPGRADE_HOME/dist
LIB_PATH=$SCRIPTS_DIR/lib
CONF_PATH=$SCRIPTS_DIR/conf
LOG4J_XML_PATH=log4j.xml
TIMEZONE="America/Los_Angeles"
UPGRADED_FILE_SUFFIX=".upgraded"
TMP_DIRECTORY=/tmp

export UPGRADE_HOME
export SCRIPTS_DIR
export LIB_PATH
export CONF_PATH
export LOG4J_XML_PATH
export TIMEZONE
export UPGRADED_FILE_SUFFIX
export TMP_DIRECTORY

logMsg "UPGRADE_HOME = $UPGRADE_HOME"
logMsg "SCRIPTS_DIR = $SCRIPTS_DIR"
logMsg "LIB_PATH = $LIB_PATH"
logMsg "CONF_PATH = $CONF_PATH"
logMsg "LOG4J_XML_PATH = $LOG4J_XML_PATH"
logMsg "TIMEZONE = $TIMEZONE"
logMsg "UPGRADED_FILE_SUFFIX = $UPGRADED_FILE_SUFFIX"
logMsg "TMP_DIRECTORY = $TMP_DIRECTORY"

CLASSPATH=$SCRIPTS_DIR
CLASSPATH=$CLASSPATH:$LIB_PATH/*
CLASSPATH=$CLASSPATH:$CONF_PATH
export CLASSPATH

logMsg "    CLASSPATH: $CLASSPATH"

if [ "x$JAVA" = "x" ]; then
    if [ "x$JAVA_HOME" != "x" ]; then
        JAVA="$JAVA_HOME/bin/java"
    else
        JAVA="java"
    fi
fi
JAVA="$JAVA -Dlog4j.configuration=$LOG4J_XML_PATH -Djava.security.egd=file:///dev/urandom -Duser.timezone=$TIMEZONE"
export JAVA

logMsg "    JAVA: $JAVA"

CMS_VERSION_1_2=1_2
CMS_VERSION_1_5=1_5
CMS_VERSION_2_0=2_0
CMS_VERSION_2_5=2_5
CMS_VERSION_3_0=3_0
CMS_VERSION_3_1=3_1

export CMS_VERSION_1_2
export CMS_VERSION_1_5
export CMS_VERSION_2_0
export CMS_VERSION_2_5
export CMS_VERSION_3_0
export CMS_VERSION_3_1

INIT_SUB_ACTIVITY="setting up /dev/random symbolic link"

logBeginMsg "$INIT_SUB_ACTIVITY"

./createLinks.sh

logDoneMsg "$INIT_SUB_ACTIVITY"

activitySeparator

logDoneMsg "$INIT_ACTIVITY"

me=$oldme

activitySeparator


   