#!/bin/sh
backupdir=/home/upgrade/2.0
upgradedir=/home/upgrade/2.5

echo "Verifying Database server"
echo "Enter SSH password for CMS user to connect to database server"
ssh cms@DBSERVER "test -f /etc/redhat-release"
if [ $? -ne 0 ]; then
        echo "Upgrade aborted, database that is trying to connect is not RHEL server. please make sure you are connecting to right 2.5 database server";
        exit;
fi

## Take backup of 2.0 files
mkdir -p $backupdir
# Copy upgraded files in once place
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/plugin.xml $backupdir/.
cp /opt/tandbergtv/cms/conf/report/report-config.xml $backupdir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml $backupdir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties $backupdir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/cfDataTypeMapping.dat $backupdir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/FieldAliasMapping.dat $backupdir/.
cp /opt/tandbergtv/cms/conf/pmm/pmm.properties $backupdir/.
cp /opt/tandbergtv/cms/conf/pmm/table-config.xml $backupdir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/tableconfiguration.xml $backupdir/.
cp /opt/tandbergtv/cms/conf/tools/links.xml $backupdir/.
cp /opt/tandbergtv/cms/conf/tools/LinkName.properties $backupdir/.

mkdir -p $upgradedir
## run metadata plugin upgrade
echo "### Upgrading Metadata plugin ###"
cd plugin
sudo -u nobody ./upgradePlugin.sh $backupdir

## run report-config.xml upgrade
echo "### Upgrading report-config.xml ###"
cd ../reports
sudo -u nobody ./scripts/run_report_config_merge.sh

## run content class upgrade
echo "### Upgrading Content class ###"
cd ../contentmgmt
sudo -u nobody ./scripts/convert_cc_db.sh

## run migration of Rating, App Type, Studio, Product 
echo "### Migrating metadata field values for Rating, App Type, Studio, Product ###"
cd ../contentmgmt
sudo -u nobody ./scripts/convert_options.sh

## run ECMF UI plugin upgrade
echo "### Upgrading ECMF UI definition.xml and ecmf.properties ###"
# Check if .beforeUpgrade file is already present then dont overwrite it. 
## This is to allow rerun of upgrade script without affecting the old backup
if [ -f /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml.beforeUpgrade ]; then

	echo "Taking backup of definition.xml, ecmf.properties and cfDataTypeMapping.dat"
else
	cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml.beforeUpgrade
	cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties.beforeUpgrade
	cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/cfDataTypeMapping.dat /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/cfDataTypeMapping.dat.beforeUpgrade
fi

cd ../contentmgmt
sudo -u nobody ./scripts/convert_spec.sh

## copy files to right location
cp out/definition.xml /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/.
cp out/ecmf.properties /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/.
cp out/cfDataTypeMapping.dat /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/.

## migrate sites
echo "### Migrating Distribution Partners to Distribution sites ###"
cd ../sites/scripts
sudo -u nobody ./upgrade.sh

## migrate FieldAliasMapping
echo "### Migrating FieldAliasMapping.dat ###"
cd ../../fieldAlias
sudo -u nobody ./upgradeFieldAlias.sh


## updating table config and pmm.properties
cd ../plugin
echo "### Upgrading table config and pmm.properties ###"
sudo -u nobody ./upgradePMMProperties.sh
sudo -u nobody ./upgradeTableConfig.sh

echo "### Upgrading tableconfiguration.xml ###"
sudo -u nobody ./upgradeTableConfiguration.sh

echo "### Upgrading tools link.xml and LinkName.properties ###"
cd ../tools
sudo -u nobody ./upgradeTools.sh

echo "Upgrade done, copying all the upgraded files to $upgradedir"
## Copy upgraded files in one place
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/plugin.xml $upgradedir/.
cp /opt/tandbergtv/cms/conf/report/report-config.xml $upgradedir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml $upgradedir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties $upgradedir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/cfDataTypeMapping.dat $upgradedir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/FieldAliasMapping.dat $upgradedir/.
cp /opt/tandbergtv/cms/conf/pmm/pmm.properties $upgradedir/.
cp /opt/tandbergtv/cms/conf/pmm/table-config.xml $upgradedir/.
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/tableconfiguration.xml $upgradedir/.
cp /opt/tandbergtv/cms/conf/tools/links.xml $upgradedir/.
cp /opt/tandbergtv/cms/conf/tools/LinkName.properties $upgradedir/.

echo "Files copied to $upgradedir...."
