#!/bin/bash
START=$(date +%s)
TIMESTAMP=`date --utc -d "@$(( $START ))" +%Y%m%d_%H%M%S`
    home=/home/upgrade
    backupdir=$home/2.5
    upgradedir=$home/3.0
    contentdir=$backupdir/content

    ## create backup dirs
    mkdir $backupdir
    mkdir $upgradedir
    mkdir $contentdir

    ## Back up 2.5 files ##
    # - definition.xml
    cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml $backupdir/.
    cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties $backupdir/.
    cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_definition.xml $backupdir/.
    cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_ecmf.properties $backupdir/.

    #- cablelabs plugins
    cp -R /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.cablelabsvod11 $contentdir

    # Stop all services
    echo "Stopping Services"
    service alerts stop
    service cms stop
    service tomcat stop
    service RCSSchedulerService stop
    service xportmanager stop
    service xporttomcat stop

    ## Run Custom Field and Content Class upgrade ##
    echo "## Upgrading Custom Fields and Content Class ##"
    cd /home/upgrade/customfields
    ./scripts/custom_fields_upgrade.sh
    echo "## Done Upgrading Custom Fields and Content Class ##"
    cd ..

    ## Upgrade Content Class Partner override ##
    echo "## Upgrading Content Class Partner override ##"
    cd /home/upgrade/customfields/
    ./scripts/content_class_partner_upgrade.sh
    echo "## Done Upgrading Content Class Partner override ##"
    cd ..

    ## Upgrade definition.xml ##
    echo "## Upgrading definition.xml, series_definition.xml, ecmf.properties and series_ecmf.properties ##"
    if [ ! -f $upgradedir/definition.xml ]; then
        cd /home/upgrade/contentmgmt
        ./scripts/convert_spec.sh
        cp /home/upgrade/contentmgmt/out/definition.xml $upgradedir/.
        cp /home/upgrade/contentmgmt/out/series_definition.xml $upgradedir/.
        cp /home/upgrade/contentmgmt/out/ecmf.properties $upgradedir/.
        cp /home/upgrade/contentmgmt/out/series_ecmf.properties $upgradedir/.
        cd ..
    else
        echo "definition.xml already upgraded, skipping ..."
    fi

    ## Copy upgraded definition.xml
    cp $upgradedir/definition.xml /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/
    cp $upgradedir/ecmf.properties /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/
    cp $upgradedir/series_definition.xml /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/
    cp $upgradedir/series_ecmf.properties /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/

    # Force change ownwership of all to nobody
    chown -R nobody:nobody /opt/tandbergtv/
    chown -R nobody:nobody /usr/local/n2bb
    
    echo "Upgrade completed."
    # end your commands
2>&1 | tee /home/upgrade/$TIMESTAMP.update.log
