##############################################################################################################
##    Script Name    : upgradeAutofillProviders.sh                                                          ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/07/2013                                                                           ##
##    Usage          : ./upgradeAutofillProviders.sh                                                        ##
##    Purpose        : Upgrade Autofill providers.                                                          ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade Autofill Providers.
##

ACTIVITY="upgrading autofill providers"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

ECMF_UI_PLUGIN_RESOURCES_DIR=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources
SPEC_FILE_NAME=definition.xml
SPEC_PROPERTIES_FILE_NAME=ecmf.properties

cd upgrade25/dist/contentmgmt/

##
## There is a separate script for converting autofill providers in 1.2->3.1 upgrade.
## For other upgrade paths, the content class upgrade takes care of autofill providers upgrade as well.
##
if [ "$upgrade_from_cms_version" == "$CMS_VERSION_1_2" ]; then
    logMsg "Invoking convert_autofill_prov_12.sh..."
    ./scripts/convert_autofill_prov_12.sh
else 
    logMsg "Nothing to do. Content Class upgrade script manages upgrade for autofill providers as well..."
fi

cd $homedir

logDoneMsg "$ACTIVITY"
