##############################################################################################################
##    Script Name    : upgradeCMSMain2_0-3_1.sh                                                             ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/23/2013                                                                           ##
##    Usage          : ./upgradeCMSMain2_0-3_1.sh                                                           ##
##    Purpose        : Main Parent script for upgrading CMS App Server from v 2.0 to v 3.1.                 ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This upgrade script assumes that the backup configuration files from previous version (e.g., 2.0) have 
##      been restored to the current CMS setup (e.g., 3.1).
##

logMsg "upgradeCMSMain2_0-3_1.sh invoked with args: $*"

ACTIVITY="upgrading CMS from version $upgrade_from_cms_version to $upgrade_to_cms_version"

logBeginMsg "$ACTIVITY"

activitySeparator

cd $SCRIPTS_DIR
             
## First do all upgrades which are required only if upgrading from CMS 2.0
./customUpgradesFromCMS2_0.sh
    
activitySeparator

cd $SCRIPTS_DIR

## Upgrade /opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties
## Commenting out because this script does not work properly for 1.2->3.1.
##./upgradeWatchfolderProperties.sh
    
activitySeparator

cd $SCRIPTS_DIR

## Upgrade report-config.xml
./upgradeReportConfig.sh
    
activitySeparator

cd $SCRIPTS_DIR

## Upgrade sites
./upgradeSitesFromCMS2_0.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
## Upgrade cms/conf/tools
./upgradeToolsFromCMS2_0.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
## Upgrade Standard Fields
./upgradeStandardFields.sh
    
activitySeparator

cd $SCRIPTS_DIR

## Upgrade spec plugins
./upgradeSpecPlugins.sh
    
activitySeparator

## Upgrade Autofill Providers
./upgradeAutofillProviders.sh
    
activitySeparator

cd $SCRIPTS_DIR
    
## Load categories ##
./loadCategories.sh
    
activitySeparator

cd $SCRIPTS_DIR

## Upgrade Content Class and definition.xml ##
## Also upgrades Custom Fields ##
./upgradeContentClass.sh
    
activitySeparator

cd $SCRIPTS_DIR
    
logDoneMsg "$ACTIVITY"
 
activitySeparator
