##############################################################################################################
##    Script Name    : upgradeContentClass.sh                                                               ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 04/08/2013                                                                           ##
##    Usage          : ./upgradeContentClass.sh                                                             ##
##    Purpose        : Script for upgrading content class, definition.xml and custom fields.                ##
##                                                                                                          ##
##############################################################################################################

#!/bin/bash

##
## Upgrade content class, definition.xml and custom fields.
##

ACTIVITY="upgrading content class, definition.xml and custom fields"

logBeginMsg "$ACTIVITY"

case "$upgrade_from_cms_version" in
    "$CMS_VERSION_1_2") 
        ./upgradeContentClassCMS1_2-3_1.sh 
        ;;
    "$CMS_VERSION_1_5") 
        ./upgradeContentClassCMS1_5-3_1.sh
        ;;
    "$CMS_VERSION_2_0") 
        ./upgradeContentClassCMS2_0-3_1.sh
        ;;
    "$CMS_VERSION_2_5") 
        ./upgradeContentClassCMS2_5-3_1.sh
        ;;
    "$CMS_VERSION_3_0") 
        ./upgradeContentClassCMS3_0-3_1.sh
        ;;
    *) 
        logMsg "Upgrade of Content Class from CMS version $upgrade_from_cms_version is not supported."
        ;;
esac

logDoneMsg "$ACTIVITY"
