##############################################################################################################
##    Script Name    : upgradeMetadataPluginXml.sh                                                          ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 07/15/2013                                                                           ##
##    Usage          : ./upgradeMetadataPluginXml.sh                                                        ##
##    Purpose        : Script for upgrading plugins/content/com.tandbergtv.metadata/plugin.xml.             ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrades plugins/content/com.tandbergtv.metadata/plugin.xml.
## This just means replacing 1.5 with 1.2 for ttvBinderVersion in plugin.xml.
##

METADATA_PLUGIN_XML_FILE_PATH=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/plugin.xml
OLD_TTV_BINDER_FRAGMENT="parameter id=\"ttvBinderVersion\" value=\"1.5\""
NEW_TTV_BINDER_FRAGMENT="parameter id=\"ttvBinderVersion\" value=\"1.2\""

ACTIVITY="upgrading METADATA_PLUGIN_XML_FILE_PATH=$METADATA_PLUGIN_XML_FILE_PATH"

logBeginMsg "$ACTIVITY"

sed -i$UPGRADED_FILE_SUFFIX "s/$OLD_TTV_BINDER_FRAGMENT/$NEW_TTV_BINDER_FRAGMENT/g" $METADATA_PLUGIN_XML_FILE_PATH

logDoneMsg "$ACTIVITY"
