##############################################################################################################
##    Script Name    : upgradePropertyFiles.sh                                                              ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/02/2013                                                                           ##
##    Usage          : ./upgradePropertyFiles.sh                                                            ##
##    Purpose        : Script for upgrading CMS property files.                                             ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade CMS property files.
##

ACTIVITY="upgrading property files"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

if [ "$CMS_VERSION_1_2" == "$upgrade_from_cms_version" ]; then
    ./upgradeContentMgmtPropertiesFile.sh
fi

cd $homedir

./upgradePMMPropertiesFile.sh

cd $homedir

echo "  JAVA: $JAVA"
echo "  CLASSPATH: $CLASSPATH"

$JAVA -classpath $CLASSPATH com.ericsson.cms.upgrade.PropertyFilesUpgradeManager $*

cd $homedir

logDoneMsg "$ACTIVITY"
