##############################################################################################################
##    Script Name    : upgradeSites.sh                                                                      ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 03/26/2013                                                                           ##
##    Usage          : ./upgradeSites.sh                                                                    ##
##    Purpose        : Script for upgrading sites.                                                          ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade sites.
##

origMonitoringFolder=/opt/tandbergtv/cms/plugins/site
newMonitoringFolder=/opt/tandbergtv/cms/plugins/site/monitoring
monitoringFiles=*
exportFolder=export
exportFolderLocation=$origMonitoringFolder
monitoringFolder=monitoring
monitoringFolderLocation=$origMonitoringFolder

tmpdir=/var/tmp
tmpmonitoringdir=$tmpdir/upgrade/monitoring

ACTIVITY="upgrading sites"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

# Move monitoring folder(s) from cms/plugins/site to cms/plugins/site/monitoring/
if [ ! -d "$newMonitoringFolder" ]; then
    logMsg "newMonitoringFolder=$newMonitoringFolder does not exist. Creating..."
    mkdir -pv $newMonitoringFolder
else
    logMsg "newMonitoringFolder=$newMonitoringFolder already exists..."
fi

mkdir -pv $tmpmonitoringdir
mv -v $origMonitoringFolder/$monitoringFiles $tmpmonitoringdir/
mv -v $tmpmonitoringdir/$exportFolder $exportFolderLocation/    
mv -v $tmpmonitoringdir/$monitoringFolder $monitoringFolderLocation/    
mv -v $tmpmonitoringdir/$monitoringFiles  $newMonitoringFolder/

cd $homedir

cd ./upgrade25/dist/sites/scripts
./upgrade.sh

cd $homedir

logDoneMsg "$ACTIVITY"

