##############################################################################################################
##    Script Name    : upgradeWorkflowTableConfig.sh                                                        ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/30/2013                                                                           ##
##    Usage          : ./upgradeWorkflowTableConfig.sh                                                      ##
##    Purpose        : Script for upgrading cms/conf/workflow/table-config.xml.                             ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade cms/conf/workflow/table-config.xml.
##

TABLE_CONFIG_PATH=/opt/tandbergtv/cms/conf/workflow/table-config.xml
QUEUED_USER_TASKS_TABLE_ID="table id=\"QueuedUserTasksTable\""
QUEUED_USER_TASKS_TABLE_FILE_NAME=QueuedUserTasksTable.xml
QUEUED_USER_TASKS_TABLE_FILE_PATH=$CONF_PATH/$QUEUED_USER_TASKS_TABLE_FILE_NAME
TEMP_FILE=$TABLE_CONFIG_PATH.temp

ACTIVITY="upgrading workflow table-config.xml: $TABLE_CONFIG_PATH"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

SUBACTIVITY="processing $QUEUED_USER_TASKS_TABLE_ID"

logBeginMsg "$SUBACTIVITY"

if grep "$QUEUED_USER_TASKS_TABLE_ID" "$TABLE_CONFIG_PATH"; then
    logMsg "$QUEUED_USER_TASKS_TABLE_ID already exists in $TABLE_CONFIG_PATH.";
    logMsg "No need to add..."
else
    # take backup of old file
    cp -vf $TABLE_CONFIG_PATH $TABLE_CONFIG_PATH.beforeUpgrade

    # Delete the line
    grep -v "</tables>" $TABLE_CONFIG_PATH > $TEMP_FILE

    # append the QUEUED_USER_TASKS_TABLE_FILE_PATH contents as a part of upgrade
    cat $QUEUED_USER_TASKS_TABLE_FILE_PATH >> $TEMP_FILE
    echo "added $QUEUED_USER_TASKS_TABLE_FILE_PATH contents to $TABLE_CONFIG_PATH"

    echo "</tables>" >> $TEMP_FILE

    #rename the file
    mv -vf $TEMP_FILE $TABLE_CONFIG_PATH
fi
 
logDoneMsg "$SUBACTIVITY"
 
cd $homedir

logDoneMsg "$ACTIVITY"
