##############################################################################################################
##    Script Name    : commandCMSServices.sh                                                                ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/13/2013                                                                           ##
##    Usage          : ./commnadCMSServices.sh <command> [<options>]                                        ##
##                             where <command> and <options> refer to respective parameters                 ## 
##                             for the linux "service" command.                                             ##
##    Purpose        : Command all CMS Services to start/stop/status etc.                                   ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script can be used to start/stop all CMS services together.
##

COMMAND_WITH_OPTIONS=$*
ACTIVITY="CMS services $COMMAND_WITH_OPTIONS"

logBeginMsg "begin $ACTIVITY"

service alerts $COMMAND_WITH_OPTIONS
service cms $COMMAND_WITH_OPTIONS
service tomcat $COMMAND_WITH_OPTIONS
service RCSSchedulerService $COMMAND_WITH_OPTIONS
service xportmanager $COMMAND_WITH_OPTIONS
service xporttomcat $COMMAND_WITH_OPTIONS
	
logDoneMsg "$ACTIVITY"
