#!/bin/sh
##############################################################################################################
##    Script Name    : getCommonBackupLocation.sh                                                           ##
##    Author         : Brandon Cox                                                                          ##
##    Created on     : 01/27/2014                                                                           ##
##    Usage          : ./getCommonBackupLocation.sh                                                         ##
##    Purpose        : Get the location of the Common Backup tar file.                                      ##
##############################################################################################################

backupTarFilePath=`cat ${CURRENT_PACKAGE_FOLDER}/conf/upgradeConf.properties | grep "commonbackup.file.path" | cut -d "=" -f 2`

# -z True of the length if "STRING" is zero.
while [[ -z $backupTarFilePath ]] ; do
	printf "%-50s\n" "Please enter location of commonbackup generated file:"
	printf "%-50s\n" "Example: /backup/cmsapp30_192.168.1.100_cms_FULL_20131226_1812.tgz"
	read backupTarFilePath
	
	# -n True if the length of "STRING" is non-zero.
	if [ -n ${backupTarFilePath} ]; then
		# -f True if FILE exists and is a regular file.
		if [ -f ${backupTarFilePath} ]; then
			printf "Restoring from file \"${backupTarFilePath}\", are you sure? [y/n] ";
			read COMFIRMED
			if [ ${COMFIRMED} == "y" ]; then
				export backupTarFilePath=$backupTarFilePath
			else
				backupTarFilePath=""
			fi
		else
			echo -e "\n The file '${backupTarFilePath}' does not exist or is not a tar file.\n"
			backupTarFilePath=""
		fi
	fi	
done
printf "%-50s\n" "Saving backupTarFilePath as \"${backupTarFilePath}\"";

export backupTarFilePath
