#!/bin/sh
##############################################################################################################
##    Script Name    : getUpgradePath.sh                                                                    ##
##    Author         : Leon Lin		                                                                        ##
##    Created on     : 12/02/2013                                                                           ##
##    Usage          : ./getUpgradePath.sh                                                                  ##
##    Purpose        : Determine the upgrade path (from version and to version)                             ##
##                       for the current CMS Upgrade.                                                       ##
##                                                                                                          ##
##############################################################################################################

##
## This script can be used to determine the upgrade path for the current CMS upgrade. 
## This script assumes that CMS database upgrade has already happened, 
##    and the system_settings table has the correct CMS version before upgrade. 
## Also the environment variables and functions need to have been already initialized
##    by sourcing ./initEnvCommon.sh.
##

me="getUpgradePath.sh"

logMsg "$me invoked with args: $*"

productPropertiesPath=/opt/tandbergtv/cms/product.properties
versionKey=product.version

ACTIVITY="getting upgrade path for the current CMS upgrade"

logBeginMsg "$ACTIVITY"
cmsVersionBeforeUpgrade=($(cat $productPropertiesPath | grep $versionKey | cut -d "=" -f 2))
logMsg "VERSION_BEFORE_FILE_PATH = $VERSION_BEFORE_FILE_PATH"


shortCMSVersionBeforeUpgrade=${cmsVersionBeforeUpgrade%.*}
if [[ $(echo "$shortCMSVersionBeforeUpgrade" | cut -b 3) == "0" ]]; then
	upgrade_from_cms_version=3.0.000
else
	upgrade_from_cms_version="${shortCMSVersionBeforeUpgrade}"
fi
upgrade_to_cms_version=$CMS_VERSION_3_1_010

if [[ ${upgrade_from_cms_version} == ${upgrade_to_cms_version} ]];then
	activitySeparator
	echo -e "\n The CMS APP is already the latest version."
	echo -n " Are you sure you would like to continue with the upgrade? [y/n] "
	read confirmation
	if [ "$confirmation" != "y" ]; then
		activitySeparator
		echo -e "\n Exiting the upgrade process."
		activitySeparator
		exit 1;
	else
		echo -en "\n Please enter the application version you are upgrading from (e.g. 3.0.000.271): "
		read cmsVersionBeforeUpgrade
		echo -e "\n Continuing upgrade with the prior version as $cmsVersionBeforeUpgrade..."
		shortCMSVersionBeforeUpgrade=${cmsVersionBeforeUpgrade%.*}
		upgrade_from_cms_version="${shortCMSVersionBeforeUpgrade}"
	fi
fi

export cmsVersionBeforeUpgrade
export shortCMSVersionBeforeUpgrade
export upgrade_from_cms_version
export upgrade_to_cms_version


logMsg "cmsVersionBeforeUpgrade = $cmsVersionBeforeUpgrade"
logMsg "shortCMSVersionBeforeUpgrade = $shortCMSVersionBeforeUpgrade"
logMsg "upgrade_from_cms_version = $upgrade_from_cms_version"
logMsg "upgrade_to_cms_version = $upgrade_to_cms_version"


logDoneMsg "$ACTIVITY"
