##############################################################################################################
##    Script Name    : initEnvCommon.sh                                                                     ##
##    Author         : Leon Lin                                                                             ##
##    Created on     : 12/30/2013                                                                           ##
##    Usage          : ./initEnvCommon.sh                                                                   ##
##    Purpose        : Script for initializing environment for upgrade of CMS App Server to version 3.1.010 ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script initializes several variables and utility functions,  
##       which are used by CMS Upgrade (upgrade.sh). 
##

./activitySeparator.sh

oldme=$me
me="initEnvCommon.sh"

echo "$me invoked with args: $*"

MESSAGE_PREFIX="    $me: "

INIT_ACTIVITY="initializing common environment variables"
INIT_ACTIVITY_MSG="$MESSAGE_PREFIX$INIT_ACTIVITY$MESSAGE_SUFFIX"

echo "$INIT_ACTIVITY_MSG"

INIT_SUB_ACTIVITY="sourcing upgrade utilities script"
INIT_SUB_ACTIVITY_MSG="$MESSAGE_PREFIX$INIT_SUB_ACTIVITY$MESSAGE_SUFFIX"

echo "$INIT_SUB_ACTIVITY_MSG"

. ./upgradeUtils.sh

logDoneMsg "$INIT_SUB_ACTIVITY"

activitySeparator

UPGRADE_HOME=/home/upgrade
SCRIPTS_DIR=$UPGRADE_HOME
LIB_PATH=$SCRIPTS_DIR/lib
CONF_PATH=$SCRIPTS_DIR/conf
LOG4J_XML_PATH=log4j.xml
TIMEZONE=$(grep -oP '"\K[^"\047]+(?=["\047])' /etc/sysconfig/clock)
UPGRADED_FILE_SUFFIX=".upgraded"
TMP_DIRECTORY=/tmp

export UPGRADE_HOME
export SCRIPTS_DIR
export LIB_PATH
export CONF_PATH
export LOG4J_XML_PATH
export TIMEZONE
export UPGRADED_FILE_SUFFIX
export TMP_DIRECTORY

logMsg "UPGRADE_HOME = $UPGRADE_HOME"
logMsg "SCRIPTS_DIR = $SCRIPTS_DIR"
logMsg "LIB_PATH = $LIB_PATH"
logMsg "CONF_PATH = $CONF_PATH"
logMsg "LOG4J_XML_PATH = $LOG4J_XML_PATH"
logMsg "TIMEZONE = $TIMEZONE"
logMsg "UPGRADED_FILE_SUFFIX = $UPGRADED_FILE_SUFFIX"
logMsg "TMP_DIRECTORY = $TMP_DIRECTORY"

CLASSPATH=$SCRIPTS_DIR
CLASSPATH=$CLASSPATH:$LIB_PATH/*
CLASSPATH=$CLASSPATH:$CONF_PATH
export CLASSPATH

logMsg "    CLASSPATH: $CLASSPATH"

if [ "x$JAVA" = "x" ]; then
    if [ "x$JAVA_HOME" != "x" ]; then
        JAVA="$JAVA_HOME/bin/java"
    else
        JAVA="java"
    fi
fi
JAVA="$JAVA -Dlog4j.configuration=$LOG4J_XML_PATH -Djava.security.egd=file:///dev/urandom -Duser.timezone=$TIMEZONE"
export JAVA

logMsg "    JAVA: $JAVA"

export CMS_VERSION_3_1_010=3.1.010

INIT_SUB_ACTIVITY="setting up /dev/random symbolic link"

logBeginMsg "$INIT_SUB_ACTIVITY"

./createLinks.sh

logDoneMsg "$INIT_SUB_ACTIVITY"

activitySeparator

logDoneMsg "$INIT_ACTIVITY"

me=$oldme

activitySeparator


   
