##############################################################################################################
##    Script Name    : upgradeCMSMain.sh	                                                            ##
##    Author         : Leon Lin                                                                             ##
##    Created on     : 12/02/2013                                                                           ##
##    Usage          : ./upgradeCMSMain.sh	                                                            ##
##    Purpose        : Get upgrade CMS version by version along the upgrade path                            ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh


upgradeScriptName=initUpdateConf.sh
postUpgradeScriptName=postUpgrade.sh
restoreConfDir="restore/restore_excludes"
Version=${cmsVersionBeforeUpgrade%.*}


#sort the folder to make sure the upgrade path is in order
folders=$(ls ./upgrade_package | sort)


for foldername in ${folders[*]} 
do

	versions=($(echo ${foldername}|tr '-' ' '|tr -s ' '))

	if [[ "${versions[0]}" == ${upgrade_from_cms_version}* ]]; then
		echo -e "\nRunning installation script"
		export CURRENT_PACKAGE_FOLDER="${UPGRADE_HOME}/upgrade_package/${foldername}"
		export CMS_FROM_VERSION=${versions[0]}
		export CMS_TO_VERSION=${versions[1]}
		export RESTORE_CONF=${CURRENT_PACKAGE_FOLDER}/${restoreConfDir}

		upgradeScript=${CURRENT_PACKAGE_FOLDER}/${upgradeScriptName}
		postUpgradeScript=${CURRENT_PACKAGE_FOLDER}/${postUpgradeScriptName}
		./upgradeCMS.sh ${upgradeScript} ${postUpgradeScript} 
		if [ $? -ne 0 ];then
			echo -e "\n Upgrade CMS APP from ${versions[0]} to ${versions[1]} failed, please check the log files"
			exit 1
		fi 


		upgrade_from_cms_version=versions[1]
	else
		echo -e "\nVersion doesn't match, skipping upgrade folder "${foldername}
	fi
	
done
