##############################################################################################################
##    Script Name    : initUpdateConf.sh                                                                    ##
##    Author         : Leon Lin	                                                                            ##
##    Created on     : 11/28/2013                                                                           ##
##    Usage          : ./initUpdateConf.sh                                                                  ##
##    Purpose        : Script for initializing configuration to upgrade CMS App Server to version 3.1.      ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script initializes variables for upgrade such as files to backup/rpm to install, etc  
## which are used by CMS Upgrade (upgradeCMS.sh). 
##
   
#################################################################
# Backup Config Files
#################################################################
CONFIG_FILES=(
    "/etc/cron.d/sysstat"
    "/etc/cron.monthly/purgeOldXportLogs.cron"
    "/etc/init.d/alerts"
    "/etc/init.d/cms"
    "/etc/init.d/RCSSchedulerService"
    "/etc/init.d/rcssnmpsubagent"
    "/etc/modprobe.d/bonding.conf"
    "/opt/tandbergtv/cms/conf/categoryMgmt/category.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/fileupload.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/imageeditor.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/SearchFieldNames.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/searchFields.xml"
    "/opt/tandbergtv/cms/conf/contentMgmt/seriesidentifiers.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/SeriesSearchFieldNames.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/seriesSearchFields.xml"
    "/opt/tandbergtv/cms/conf/contentMgmt/ui.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/videoplayer.properties"
    "/opt/tandbergtv/cms/conf/monitoring/agent.properties"
    "/opt/tandbergtv/cms/conf/pmm/assettypes.txt"
    "/opt/tandbergtv/cms/conf/pmm/auth.xml"
    "/opt/tandbergtv/cms/conf/pmm/job.properties"
    "/opt/tandbergtv/cms/conf/pmm/pmm.properties"
    "/opt/tandbergtv/cms/conf/pmm/progress.xml"
    "/opt/tandbergtv/cms/conf/pmm/requiredFileFields.txt"
    "/opt/tandbergtv/cms/conf/pmm/search-page-config.xml"
    "/opt/tandbergtv/cms/conf/pmm/table-config.xml"
    "/opt/tandbergtv/cms/conf/pmm/ui.properties"
    "/opt/tandbergtv/cms/conf/rcs/ETV_EPG.xsd"
    "/opt/tandbergtv/cms/conf/rcs/properties/Config.properties"
    "/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties"
    "/opt/tandbergtv/cms/conf/scheduler/scheduler.properties"
    "/opt/tandbergtv/cms/conf/scheduler/ui.properties"
    "/opt/tandbergtv/cms/conf/services/ingest.properties"
    "/opt/tandbergtv/cms/conf/site/dist-templates.xml"
    "/opt/tandbergtv/cms/conf/site/MSOOverridables.dat"
    "/opt/tandbergtv/cms/conf/site/ui.properties"
    "/opt/tandbergtv/cms/conf/titleListMgmt/titleListMgmt.properties"
    "/opt/tandbergtv/cms/conf/tools/LinkName.properties"
    "/opt/tandbergtv/cms/conf/tools/links.xml"
    "/opt/tandbergtv/cms/conf/workflow/auth.xml"
    "/opt/tandbergtv/cms/conf/workflow/cluster.properties"
    "/opt/tandbergtv/cms/conf/workflow/search-page-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/table-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/ui.properties"
    "/opt/tandbergtv/cms/conf/workflow/url-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/watchfolder.xml"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/adi.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/fileURIConverter.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/jacorb.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/version.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/mail-service.xml"
    "/opt/tandbergtv/cms/plugins/content/com.ericsson.metadata.series/resources/mapping.dat"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/plugin.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/previewstylesheet.xsl"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_definition.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_ecmf.properties"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/tableconfiguration.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/com/tandbergtv/workflow/webservice/filesubsystem/ftpconfiguration.txt"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/com/tandbergtv/workflow/webservice/filesubsystem/FTPClientServiceEnhancement.class"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/com/tandbergtv/workflow/webservice/filesubsystem/messagehandler/FTPDeleteMessageHandler.class"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/log4j.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/log4j.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.xml"
    "/usr/local/acsserver/scripts/AdiNameService"
    "/usr/local/n2bb/alerts/conf/AlertEmail.template"
    "/usr/local/n2bb/alerts/conf/jacorb.properties"
    "/usr/local/n2bb/conf/alerts_settings.conf"
    "/usr/local/platform/backup/bin/commonbackup_oracle_full_back.sh"
    "/usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh"
    "/usr/local/platform/backup/conf/cms/cms_directories.txt"
    "/usr/local/platform/backup/conf/cms/cms_files.txt"
    "/usr/local/platform/warmstandby/conf/warmstandby.cfg"
)

## Application Packages
                #cablelabs1_1 Excluded
APP_PACKAGES="  aide
                alerts
                category-management-resourcetype
                cms-monitoring
                cms-userguide
                content-management-resourcetype
                content-trafficking-resourcetype
                contract-manager-resourcetype
		cms-distribution-resourcetype
                ffmpeg
                ffmpeg-resourcetype
                ffmpeg-webservice
                filemanager
                filesubsystem-resourcetype
                ftp
                glibc
                gtk2
                Helix
                human-resourcetype
                ImageMagick
                imagemagick-resourcetype
                imagemagick-webservice
                info-cms
                info-nobody
                info-platform
                info-sftpuser
                info-tstv
                jack-audio-connection-kit
                jboss
                libfaac0
                licensing-test
                mediawareeditcl
                mediaware-resourcetype
                metadata-enhancement-resourcetype
                path-converter-resourcetype
                RCS
                rpcbind
                rule-engine-resourcetype
                scac-tools
                site-manager-resourcetype
                sysprep
                tomcat
                vcs-cfg
                vsftpd
                vsftpd-tstv-cfg
                warmstandby
                watchfolder
                watch-folder-resourcetype
                watchpoint-cms
                x264
                xportcombinerwebservice
                xportmanager
                xporttomcat
                xportverifier
                xport-verifier-resourcetype
                xportverifierwebservice"
                
## 3rd Party Packages 
ACC_PACKAGES="  VRTSamf
                VRTSatClient
                VRTSatServer
                VRTScps
                VRTSgab
                VRTSllt
                VRTSperl
                VRTSspt
                VRTSvcs
                VRTSvcsag
                VRTSvcsdr
                VRTSvcsea
                VRTSvcsm
                VRTSvlic
                VRTSvxfen"

## Base OS Packages installed as part of the Kickstart
BASE_PACKAGES=" @Core
                bc
                cmsstaging
                cms-systems-audit
                commonbackup
                dmidecode
                dos2unix
                eject
                file
                jdk
                man
                mutt
                net-snmp
                net-snmp-utils
                nfs-utils
                ntp
                sysstat
                system-config-network-tui
                tcpdump
                zip
                samba
                hpacucli
                bwm-ng"

#Service to stop
SERVICE=(   'alerts'
            'cms'
            'rmserver'
            'tomcat'
            'xportmanager'
            'xporttomcat'
            'RCSSchedulerService'
            'autorsync'
)

#Files that need to be removed
CLEANUP=(   '/workflow/lib/com.ericsson.cms.templates.jar'
            '/workflow/templates/Target Title.par'
)
