##############################################################################################################
##    Script Name    : postUpgrade.sh                                                                       ##
##    Author         : Leon Lin                                                                             ##
##    Created on     : 04/12/2013                                                                           ##
##    Usage          : ./postUpgrade.sh                                                                     ##
##    Purpose        : Script for post upgrading actions, update/merge configuraitons, etc                  ##
##                                                                                                          ##
##############################################################################################################
#!/bin/bash

cd ${CURRENT_PACKAGE_FOLDER}

## Upgrade Custom Fields, Content Class, and definition.xml
#./upgradeCustomFields.sh


## Upgrade report-config.xml
./upgradeReportConfig.sh


## Upgrade templates
./upgradeTemplates.sh


## fix redundant report
./fixRepackReport.sh

## change rcs setting value to lower case to avoid rcs setting ui bug
./updateRCSSetting.sh

## fix sftpuser permission
./updateSFtpUser.sh

## Update pmm/table-config.xml
./upgradePMMTableConfig.py

## Format pmm/table-config.xml
export XMLLINT_INDENT=$'\t'
xmllint --format /opt/tandbergtv/cms/conf/pmm/table-config.xml -o /opt/tandbergtv/cms/conf/pmm/table-config.xml
