##############################################################################################################
##    Script Name    : upgradeReportConfig.sh                                                               ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 07/10/2013                                                                           ##
##    Usage          : ./upgradeReportConfig.sh                                                             ##
##    Purpose        : Script for upgrading report-config.xml.                                              ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade report-config.xml.
##

ACTIVITY="upgrading report-config.xml"

REPORT_CONFIG_XML_TARGET_FILE_PATH=/opt/tandbergtv/cms/conf/report/report-config.xml
REPORT_SOURCE_FILE_PATH=/opt/tandbergtv/jreport/workspace/jreports/
REPORT_TARGET_FILE_PATH=/opt/tandbergtv/jreport/deploy/
EXCLUDE_REPORT_CATEGORY_SAMPLE="SampleReports"
EXCLUDE_REPORT_CATEGORY_WP="WPCatalog"

REPORTS_PREFIX=/Reports
REPORTS_CATALOG_NAME_PREFIX=$REPORTS_PREFIX
REPORTS_REPORT_NAME_PREFIX=$REPORTS_PREFIX


CATALOG_NAME_FRAGMENT="<catalogName>"
REPORT_NAME_FRAGMENT="<reportName>"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 


if [ -f "$REPORT_CONFIG_XML_TARGET_FILE_PATH" ]; then
    SUB_ACTIVITY="upgrading $REPORT_CONFIG_XML_TARGET_FILE_PATH"

    logBeginMsg "$SUB_ACTIVITY"

    inputFile=$REPORT_CONFIG_XML_TARGET_FILE_PATH
    tmpOutputFile="$REPORT_CONFIG_XML_TARGET_FILE_PATH.upgraded.tmp"
    if [ -f "$tmpOutputFile" ]; then
        SUB_SUB_ACTIVITY="removing previous $tmpOutputFile"
        
        logMsg "$SUB_SUB_ACTIVITY"
        
        mv -bvf "$tmpOutputFile" "$tmpOutputFile.archive"

        logDoneMsg "$SUB_SUB_ACTIVITY"
    fi
    
    SUB_SUB_ACTIVITY="processing $inputFile"
        
    logBeginMsg "$SUB_SUB_ACTIVITY"
        
    while read line; do 
        upgradedLine=$line
        
        if echo "$line" | grep -q "$CATALOG_NAME_FRAGMENT" ; then
            if ! echo "$line" | grep -q "$CATALOG_NAME_FRAGMENT$REPORTS_CATALOG_NAME_PREFIX" ; then
                SUB_SUB_ACTIVITY="prepending $REPORTS_CATALOG_NAME_PREFIX to catalog name in $line"
                
                logMsg "$SUB_SUB_ACTIVITY"
                
                catalogNameIndex=`expr index "$line" "$CATALOG_NAME_FRAGMENT"`
                catalogNameLength=`expr length "$CATALOG_NAME_FRAGMENT"`
                indexCatalogNameEnd=$((catalogNameIndex + catalogNameLength - 1))
                lineMinus="${line:$indexCatalogNameEnd}"
                upgradedLine="$CATALOG_NAME_FRAGMENT$REPORTS_CATALOG_NAME_PREFIX$lineMinus" 
            fi
        elif echo "$line" | grep -q "$REPORT_NAME_FRAGMENT" ; then
            if ! echo "$line" | grep -q "$REPORT_NAME_FRAGMENT$REPORTS_REPORT_NAME_PREFIX" ; then
                SUB_SUB_ACTIVITY="prepending $REPORTS_REPORT_NAME_PREFIX to report name in $line"
                
                logMsg "$SUB_SUB_ACTIVITY"
                
                reportNameIndex=`expr index "$line" "$REPORT_NAME_FRAGMENT"`
                reportNameLength=`expr length "$REPORT_NAME_FRAGMENT"`
                indexReportNameEnd=$((reportNameIndex + reportNameLength - 1))
                lineMinus="${line:$indexReportNameEnd}"
                upgradedLine="$REPORT_NAME_FRAGMENT$REPORTS_REPORT_NAME_PREFIX$lineMinus" 
            fi
        fi
        
        echo "$upgradedLine" >> "$tmpOutputFile"
    done < $inputFile

    logDoneMsg "$SUB_SUB_ACTIVITY"

    if [ -f "$tmpOutputFile" ]; then
        SUB_SUB_ACTIVITY="moving $tmpOutputFile to $REPORT_CONFIG_XML_TARGET_FILE_PATH"
        
        logBeginMsg "$SUB_SUB_ACTIVITY"
        
        xmllint --output "$REPORT_CONFIG_XML_TARGET_FILE_PATH" --format "$tmpOutputFile" 

        logDoneMsg "$SUB_SUB_ACTIVITY"
    fi

    logDoneMsg "$SUB_ACTIVITY"
    
else 
    logMsg "No such file: $REPORT_CONFIG_XML_TARGET_FILE_PATH"
    logMsg "No report config to upgrade..."    
fi

##
## Move reports to deploy folder.1;2c
##

for REPORT_FOLDER in `ls ${REPORT_SOURCE_FILE_PATH}`
do
	if [[ "${REPORT_FOLDER}" != "${EXCLUDE_REPORT_CATEGORY_SAMPLE}" && "${REPORT_FOLDER}" != "${EXCLUDE_REPORT_CATEGORY_WP}" ]]; then
		cp -vrf ${REPORT_SOURCE_FILE_PATH}${REPORT_FOLDER} ${REPORT_TARGET_FILE_PATH}
		rm -rf ${REPORT_SOURCE_FILE_PATH}${REPORT_FOLDER}
	fi
done


cd $homedir

logDoneMsg "$ACTIVITY"

