##############################################################################################################
##    Script Name    : upgradeTemplates.sh                                                                  ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 06/14/2013                                                                           ##
##    Usage          : ./upgradeTemplates.sh                                                                ##
##    Purpose        : Upgrade out of the box workflow templates to latest versions from CMS 3.1.           ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script upgrades out of the box workflow templates to latest versions from CMS 3.1.
## Basically this involves, packaging the 3.1 templates along with the upgrade script,
##     and copying them over to the templates watchfolder during upgrade process.
##

me=`basename $0`

logMsg "$me invoked with args: $*"

ACTIVITY="upgrading CMS workflow templates to version 3.1"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

CMS_WORKFLOW_TEMPLATES_INGEST_FOLDER=/opt/tandbergtv/cms/workflow/templates
UPGRADE_TEMPLATES_FOLDER=./templates

if [ "$(ls -A ${UPGRADE_TEMPLATES_FOLDER})" ];then
	cp -vf --backup=numbered $UPGRADE_TEMPLATES_FOLDER/* $CMS_WORKFLOW_TEMPLATES_INGEST_FOLDER/ || echo -e "\nCopy template failed, please manually copy template under $UPGRADE_TEMPLATES_FOLDER to $CMS_WORKFLOW_TEMPLATES_INGEST_FOLDER"
else
	echo -e "There're no template in the upgrade template folder"
fi

cd $homedir

logDoneMsg "$ACTIVITY"
