##############################################################################################################
##    Script Name    : upgradeUtils.sh                                                                      ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/13/2013                                                                           ##
##    Usage          : ./upgradeUtils.sh                                                                    ##
##    Purpose        : Utility shell functions for CMS upgrade.                                             ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Define variables used by upgrade utility functions.
##

oldme=$me
me="upgradeUtils.sh"

echo "$me invoked with args: $*"

LOG_MSG_INDENT="    "
BEGIN_MSG_PREFIX=""
DONE_MSG_PREFIX="done "
RUN_SCRIPT_ACTIVITY_PREFIX="executing script: "
RUN_UPGRADE_SCRIPT_ACTIVITY_PREFIX="executing upgrade script: "
SERVICE_START_COMMAND=start
SERVICE_STOP_COMMAND=stop

currentTimestampStr=""

export LOG_MSG_INDENT
export BEGIN_MSG_PREFIX
export DONE_MSG_PREFIX
export RUN_SCRIPT_ACTIVITY_PREFIX
export RUN_UPGRADE_SCRIPT_ACTIVITY_PREFIX
export SERVICE_START_COMMAND
export SERVICE_STOP_COMMAND

export currentTimestampStr

##
## Define the functions.
##

##
##  This function prints out the separator lines between various activities in the Upgrade log files.
##
activitySeparator() {
    ./activitySeparator.sh
}

##
## Log the given message.
##
logMsg() {
    local baseScriptName=`basename $0`
    local logMsgPrefix="$baseScriptName:"
    local completeLogMsg="$LOG_MSG_INDENT$logMsgPrefix $*"
    echo "$completeLogMsg"
}

##
## Log begin message.
##
logBeginMsg() {
    logMsg "$BEGIN_MSG_PREFIX$*...$(date)"
}

##
## Log done message.
##
logDoneMsg() {
    logMsg "$DONE_MSG_PREFIX$*...$(date)"
}

##
## Run the given script.
##
runScript() {
    RUN_SCRIPT_ACTIVITY="$RUN_SCRIPT_ACTIVITY_PREFIX$*"

    logBeginMsg "$RUN_SCRIPT_ACTIVITY"

    $*

    logDoneMsg "$RUN_SCRIPT_ACTIVITY"
}

##
## Run the given upgrade script.
## The upgrade script is required to be in the current directory.
##
runUpgradeScript() {
    RUN_UPGRADE_SCRIPT_ACTIVITY="$RUN_UPGRADE_SCRIPT_ACTIVITY_PREFIX$*"

    logBeginMsg "$RUN_UPGRADE_SCRIPT_ACTIVITY"

    runScript ./$*

    logDoneMsg "$RUN_UPGRADE_SCRIPT_ACTIVITY"
}

##
## Stop CMS services.
##
stopCMSServices() {
    runScript ./commandCMSServices.sh $SERVICE_STOP_COMMAND 
}

##
## Start CMS services.
##
startCMSServices() {
    runScript ./commandCMSServices.sh $SERVICE_START_COMMAND 
}

##
## Generate a string representing the current timestamp and put it in TIMESTAMP_STR variable.
##
genCurrentTimestampStr() {
    local now=$(date +%s)
    currentTimeStampStr=`date --utc -d "@$(( $now ))" +%Y%m%d_%H%M%S`
}


##
## Export the functions.
##

UTILS_ACTIVITY="exporting common functions"

logBeginMsg "$UTILS_ACTIVITY"

export -f activitySeparator
export -f logMsg
export -f logBeginMsg
export -f logDoneMsg
export -f runScript
export -f runUpgradeScript
export -f stopCMSServices
export -f startCMSServices
export -f genCurrentTimestampStr

logDoneMsg "$UTILS_ACTIVITY"

me=$oldme

