#!/bin/sh
INSTALL_DIR=$1

if [ -f "/home/oracle/ecmf/ECMFSpec.xsd" ];  then
   cp -f /home/oracle/ecmf/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec_before_$(date +"%Y%m%d_%H%M%S").xsd
   mv -f /home/oracle/ecmf/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec_old.xsd

   cp -f /home/oracle/ecmf/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans_before_$(date +"%Y%m%d_%H%M%S").xsl 2> /dev/null
   mv -f /home/oracle/ecmf/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans_old.xsl 2> /dev/null

   cp -f ${INSTALL_DIR}/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec.xsd
   cp -f ${INSTALL_DIR}/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans.xsl 2> /dev/null
else
   mkdir -p /home/oracle/ecmf
   cp -f ${INSTALL_DIR}/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec.xsd
   cp -f ${INSTALL_DIR}/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans.xsl 2> /dev/null
fi
cp -f ${INSTALL_DIR}/default_content_class.xml /home/oracle/ecmf/default_content_class.xml
cp -f ${INSTALL_DIR}/category_content_class.xml /home/oracle/ecmf/category_content_class.xml
cp -f ${INSTALL_DIR}/series_content_class.xml /home/oracle/ecmf/series_content_class.xml

mkdir -p /home/oracle/scripts/cms

cp -f ${INSTALL_DIR}/purge_error_log_script.sql  /home/oracle/scripts/cms/purge_error_log_script.sql
cp -f ${INSTALL_DIR}/purge_cms_wos.sh            /home/oracle/scripts/cms/purge_cms_wos.sh
cp -f ${INSTALL_DIR}/purge_cms_data_readme.txt   /home/oracle/scripts/cms/purge_cms_data_readme.txt
cp -f ${INSTALL_DIR}/PurgeCMS.sql                /home/oracle/scripts/cms/PurgeCMS.sql
cp -f ${INSTALL_DIR}/purge_cms_titles.sh         /home/oracle/scripts/cms/purge_cms_titles.sh
cp -f ${INSTALL_DIR}/purge_cms_titles.sql        /home/oracle/scripts/cms/purge_cms_titles.sql
cp -f ${INSTALL_DIR}/purge_cms_data.sh           /home/oracle/scripts/cms/purge_cms_data.sh

chmod 755 /home/oracle/scripts/cms/*.sh
touch /home/oracle/scripts/cms/purge_titles.log /home/oracle/scripts/cms/purge_wo.log /home/oracle/scripts/cms/purge_cms.log


sqlplus '/ as sysdba' @createWFS.sql
sqlplus '/ as sysdba' @createCM.sql "WFS"
sqlplus 'wfs/Wf$1234' @PurgeCMS.sql
sqlplus -S /nolog <<EOF
connect / as sysdba
set serveroutput on
SET VERIFY OFF
set echo on
set pagesize 100
set linesize 200 
column INSTALL_MESSAGE format a80
  select * from install_table;
EOF
cp -f ${INSTALL_DIR}/collect_db_stats.sh /home/oracle/scripts/collect_db_stats.sh 2>1 >> /dev/null
chmod 755 /home/oracle/scripts/collect_db_stats.sh
crontab -l > ${INSTALL_DIR}/old_crontab
sed -i "/collect_db_stats[.]*/d" ${INSTALL_DIR}/old_crontab
echo "0 3 * * * /home/oracle/scripts/collect_db_stats.sh" >> ${INSTALL_DIR}/old_crontab
crontab ${INSTALL_DIR}/old_crontab
echo "Added the Database Statistics collection job to the crontab successfully....."
exit 0
