#!/bin/bash
#
#	CMSsetup.sh
#	By:  Alex Rombro
#	12/2012
#
###### Description####
#
#	Developed to aid setup of CMS based systems
#	
#	Version 1 -- 12/2012 -- PoC version
#		ntp -- based on America/Los_Angeles, public site is LA
#		no confirmation, run-once
#		log file is difficult to read
#
#	Version 2 -- 1/2013 -- configuration options, final choice on script
#
#	Version 3 -- 3/2013 -- moved to rpm, choice on configurations, auto-determine CMS type, commonbackup configuration
#		
#####################
#start log file
LOG=/home/cmsstaging/log/CMSconfig.log
(
echo "###################### Script start ############"
date
echo "###################################################"
	
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

## Get CMS system type
cmstype=0
if rpm -qa | grep -i watchpoint-cms > /dev/null ; then
	cmstype=1
elif rpm -qa | grep oracleEE > /dev/null ; then
	if rpm -qa | grep RM > /dev/null ; then
		cmstype=3
	else
		cmstype=2
	fi
elif rpm -qa | grep RTC > /dev/null ; then
        cmstype=4
else
	echo "1.  CMS Application Server"
	echo "2.  CMS Database Server"
	echo "3.  CMS Recording Manager"
	echo "4.  CMS Real Time Capture"
	echo -n "Please type the number of the CMS System type to be configured? [1, 2, 3, 4]:  "
	read cmstype
fi
sed -i "s/CMSTYPE=${CMSTYPE}/CMSTYPE=${cmstype}/" ${CONFIG_FILE}

mkdir -p /tmp/flags

if [ ${cmstype} -eq 1 ] ; then
	echo "CMS Application Server"
        d=""
        while [[ -z ${d} ]] ; do
		echo ""
		echo ""
		tmpIPADDR=`grep DATAIPADDR /tmp/networkinfo.conf | cut -f2 -d'='`
		echo "IP Address:  ${tmpIPADDR}"
		cat /tmp/ntpinfo.conf
		cat /tmp/monitoringinfo.conf
		cat /tmp/backupinfo.conf
		cat /tmp/dbinfo.conf
		echo ""
		echo ""
		echo "1.  System Network"
		echo "2.  SNMP Monitoring"
		echo "3.  Network Time Synchronization"
		echo "4.  CommonBackup"
		echo "5.  Database Server"
		echo ""
		echo "A.  All of the above"
		echo ""
		echo "C.  Complete the setup"
		echo ""
		echo "Q.  Quit"
		echo ""
		echo -n "Select the component you would like to configure:  "
		read cfg
		case ${cfg} in
			1) 
				sh ${SCRIPT}/networkconf.sh
				touch /tmp/flags/network
				;;
			2) 
				sh ${SCRIPT}/snmpconf.sh
				touch /tmp/flags/monitor 
				;;
			3) 
				sh ${SCRIPT}/ntpconf.sh
				touch /tmp/flags/ntp
				;;
			4) 
				sh ${SCRIPT}/commonbackup_config.sh
				touch /tmp/flags/commonbackup
				;;
			5) 
				sh ${SCRIPT}/appdbconf.sh
				touch /tmp/flags/appdb
				;;
			"A"|"a")
				sh ${SCRIPT}/networkconf.sh
        			sh ${SCRIPT}/snmpconf.sh
	        		sh ${SCRIPT}/ntpconf.sh
        			sh ${SCRIPT}/commonbackup_config.sh
        			sh ${SCRIPT}/appdbconf.sh
				touch /tmp/flags/all
				;;
			"C"|"c") 
				sh ${SCRIPT}/finalsetup.sh
				;;
			"Q"|"q")
                                d=0
                                ;;
			*) 
				echo "Not a valid option, please select again" 
				;;
		esac
	done
elif [ ${cmstype} -eq 2 ] ; then
	echo "DB Appliance"
	echo ""
	echo ""
	d=""
        while [[ -z ${d} ]] ; do
		tmpIPADDR=`grep DATAIPADDR /tmp/networkinfo.conf | cut -f2 -d'='`
	        echo "IP Address:  ${tmpIPADDR}"
        	cat /tmp/ntpinfo.conf
	        cat /tmp/monitoringinfo.conf
		cat /tmp/backupinfo.conf
		echo ""
		echo ""
		echo "1.  System Network"
		echo "2.  SNMP Monitoring"
		echo "3.  Network Time Synchronization"
		echo "4.  CommonBackup"
		echo ""
		echo "A.  All of the above"
		echo ""
		echo "C.  Complete the setup"
		echo ""
		echo "Q.  Quit"
		echo ""
		echo -n "Select the component you would like to configure:  "
		read cfg
		case ${cfg} in
			1) 
				sh ${SCRIPT}/networkconf.sh
				touch /tmp/flags/network
				;;
			2) 
				sh ${SCRIPT}/snmpconf.sh
				touch /tmp/flags/monitor 
				;;
			3) 
				sh ${SCRIPT}/ntpconf.sh
				touch /tmp/flags/ntp
				;;
			4) 
				sh ${SCRIPT}/commonbackup_config.sh
				touch /tmp/flags/commonbackup 
				;;
			"A"|"a")
				sh ${SCRIPT}/networkconf.sh
        			sh ${SCRIPT}/snmpconf.sh
        			sh ${SCRIPT}/ntpconf.sh
        			sh ${SCRIPT}/commonbackup_config.sh
				touch /tmp/flags/all
        			;;
			"C"|"c") 
				sh ${SCRIPT}/finalsetup.sh 
				;;
			"Q"|"q")
                                d=0
                                ;;
			*) 
				echo "Not a valid option, please select again" 
				;;
		esac
	done	
elif [ ${cmstype} -eq 3 ] ; then
	echo "RM Appliance"
	d=""
        while [[ -z ${d} ]] ; do
		echo ""
		echo ""
		tmpIPADDR=`grep DATAIPADDR /tmp/networkinfo.conf | cut -f2 -d'='`
	        echo "IP Address:  ${tmpIPADDR}"
        	cat /tmp/ntpinfo.conf
		cat /tmp/monitoringinfo.conf
		cat /tmp/backupinfo.conf
		cat /tmp/ftpinfo.conf
		cat /tmp/rtcinfo.conf
		echo ""
		echo ""
		echo "1.  System Network"
		echo "2.  SNMP Monitoring"
		echo "3.  Network Time Synchronization"
		echo "4.  CommonBackup"
		echo "5.  Backoffice System"
		echo "6.  FTP User"
		echo "7.  Capture Device"
		echo ""
		echo "A.  All of the above"
		echo ""
		echo "C.  Complete the setup"
		echo ""
		echo "Q.  Quit"
		echo ""
		echo -n "Select the component you would like to configure:  "
		read cfg
		case ${cfg} in
			1) 
				sh ${SCRIPT}/networkconf.sh
				touch /tmp/flags/network
				;;
			2) 
				sh ${SCRIPT}/snmpconf.sh
				touch /tmp/flags/monitor 
				;;
			3) 
				sh ${SCRIPT}/ntpconf.sh
				touch /tmp/flags/ntp
				;;
			4) 
				sh ${SCRIPT}/commonbackup_config.sh
				touch /tmp/flags/commonbackup 
				;;
			5) 	
				sh ${SCRIPT}/backofficeconf.sh 
				touch /tmp/flags/backoffice
				;;
			6) 
				sh ${SCRIPT}/ftpuserconf.sh 
				touch /tmp/flags/ftpuser
				;;
			7) 
				sh ${SCRIPT}/rmrtcconf.sh 
				touch /tmp/flags/rmrtc
				;;
			"A"|"a")
				sh ${SCRIPT}/networkconf.sh
        			sh ${SCRIPT}/snmpconf.sh
        			sh ${SCRIPT}/ntpconf.sh
        			sh ${SCRIPT}/commonbackup_config.sh
        			sh ${SCRIPT}/backofficeconf.sh
				sh ${SCRIPT}/ftpuserconf.sh
				sh ${SCRIPT}/rmrtcconf.sh
				touch /tmp/flags/all				
				;;
			"C"|"c") 
				sh ${SCRIPT}/finalsetup.sh 
				;;
			"Q"|"q")
				d=0
				;;
			*) 
				echo "Not a valid option, please select again" 
				;;
		esac
	done	
elif  [ ${cmstype} -eq 4 ]  ; then
	echo "RTC Appliance"
	d=""
        while [[ -z ${z} ]] ; do
		echo ""
		echo ""
		tmpIPADDR=`grep DATAIPADDR /tmp/networkinfo.conf | cut -f2 -d'='`
		echo "IP Address:  ${tmpIPADDR}"
	        cat /tmp/ntpinfo.conf
		cat /tmp/monitoringinfo.conf
		cat /tmp/backupinfo.conf
		cat /tmp/ftpinfo.conf
		cat /tmp/rtcinfo.conf
		echo ""
		echo ""
		echo "1.  System Network"
		echo "2.  SNMP Monitoring"
		echo "3.  Network Time Synchronization"
		echo "4.  CommonBackup"
		echo "5.  FTP User Configuration"
		echo "6.  RTC Configuration"
		echo ""
		echo "A.  All of the above"
		echo ""
		echo "C.  Complete the setup"
		echo ""
		echo "Q.  Quit"
		echo ""
		echo -n "Select the component you would like to configure:  "
		read cfg
		case ${cfg} in
			1) 
				sh ${SCRIPT}/networkconf.sh 
				touch /tmp/flags/network
				;;
			2) 
				sh ${SCRIPT}/snmpconf.sh 
				touch /tmp/flags/monitor				
				;;
			3) 
				sh ${SCRIPT}/ntpconf.sh
				touch /tmp/flags/ntp
				;;
			4) 
				sh ${SCRIPT}/commonbackup_config.sh
				touch /tmp/flags/commonbackup 
				;;
			5) 
				sh ${SCRIPT}/ftpuserconf.sh
				touch /tmp/flags/ftpuser
				;;
			6) 
				sh ${SCRIPT}/rtcconf.sh
				touch /tmp/flags/rtc
				;;
			"A"|"a")
				sh ${SCRIPT}/networkconf.sh
        			sh ${SCRIPT}/snmpconf.sh
        			sh ${SCRIPT}/ntpconf.sh
        			sh ${SCRIPT}/commonbackup_config.sh
        			sh ${SCRIPT}/ftpuserconf.sh
				sh ${SCRIPT}/rtcconf.sh
				touch /tmp/flags/all
				;;
			"C"|"c") 
				sh ${SCRIPT}/finalsetup.sh
				;;
			"Q"|"q")
				d=0
				;;
			*) 
				echo "Not a valid option, please select again" 
				;;
		esac
	done
else	
	echo "not a known appliance"
fi

rm -fR /tmp/flags
	
echo "###################### Script complete ############"
date
echo "###################################################"
) 2>&1 | tee -a $LOG

exit 0
