#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

read -p "What is the IP Address of your DB Server? [${DBIP}]  " tmpdb
tmpdb=${tmpdb:-${DBIP}}
echo "DBIP=${tmpdb}" > /tmp/dbinfo.conf
echo " "
sed -i "s/DBIP=${DBIP}/DBIP=${tmpdb}/" ${CONFIG_FILE}
echo " "   	

# clean up temp files
#rm /tmp/dbinfo.conf

exit 0
