#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

cont=n
while [ ${cont} = n ]; do
	tmpdownstreamtype=0
	echo "1.  AMS (version 4.X or lower)"
	echo "2.  AMS (version 5.X or higher)"
	echo "3.  OpenStream (version 4.4 or lower)"
	echo "4.  OpenStream (version 4.5 or higher)"
	echo "5.  CMS (version 1.2 or higher)"
	echo -n "Please select the type of Back Office or Downstream system to be used [1, 2, 3, 4, 5]?  "
	read tmpdownstreamtype
	echo " "
	read -p "What is the IP Address of the Back Office or Downstream system to be used [${DSIP}]?  " tmpDSIP
	echo "DSIP=${tmpDSIP}" > /tmp/backofficeinfo.conf
	echo "DOWNSTREAMTYPE=${tmpdownstreamtype}" >> /tmp/backofficeinfo.conf
	echo " "
	cat /tmp/backofficeinfo.conf
	echo " "
	read -p "Is this correct?  " correct
	echo " "
	case ${correct} in
		"y"|"Y"|"yes"|"Yes")
			sed -i "s/DOWNSTREAMTYPE=${DOWNSTREAMTYPE}/DOWNSTREAMTYPE=${tmpdownstreamtype}/" ${CONFIG_FILE}
			sed -i "s/DSIP=${DSIP}/DSIP=${tmpDSIP}/" ${CONFIG_FILE}
			cont=y
			;;
		*)
			cont=n
			;;
	esac
done

# Cleanup /tmp
#rm /tmp/backofficeinfo.conf

exit 0
