#!/bin/bash
# 
# script to configure commonbackup.cfg file
# will also provide modifications to:
#	/etc/fstab
#	/etc/postfix/main.cf
#	/usr/local/platform/backup/bin/commonbackup_oracle_full_back.sh
#	/usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh
#	/opt/oracle/backup/scripts/rman_backup_arch.ksh
#	/opt/oracle/backup/scripts/rman_backup.ksh
# if the system is a CMS DB or CMS RM, the oracle database will be placed into archive mode
#
# Information required before running script
#	IP or Hostname of NFS server
#	Location on NFS Server for mounting
#	Local mount point for NFS sharing (does not need to exist prior to running this script)
#	Email relayhost 
#	Local IP Address 
#	Valid Email Address
#	Database servers will need to know the length of the data retention desired
#

#/usr/local/platform/backup/bin/configfileprep.sh


#### Configuration file modification #############
BACKUP_CONFIG=/usr/local/platform/backup/conf/commonbackup.cfg
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE} ${BACKUP_CONFIG}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done


###################################################
EMAIL=""
echo "What is the email address to be used for notifications of backup status? [${BAK_ADMIN}]  "
read EMAIL 
echo "EMAIL=${EMAIL}" > /tmp/backupinfo.conf 

echo "What is the IP Address or Host Name of the email server for the relayhost?  "
read relay
echo "relayhost=${relay}" >> /tmp/backupinfo.conf
BACKUP_LOC=""
echo "What is the full path and direcory of backup mount point? [${SAN}]  "
read BACKUP_LOC
echo "BACKUP_LOC=${BACKUP_LOC}" >> /tmp/backupinfo.conf

if [ ${CMSTYPE} -eq 1 ]; then
	APP=cms
elif [ ${CMSTYPE} -eq 2 ]; then
	APP=cms
elif [ ${CMSTYPE} -eq 3 ]; then
	APP=tstv
elif [ ${CMSTYPE} -eq 4 ]; then
	APP=tstv
else
	echo "Not a valid Application for cmsbackup"
fi
echo "APP=${APP}" >> /tmp/backupinfo.conf

exit 0

