#!/bin/bash
# 
# script to configure commonbackup.cfg file
# will also provide modifications to:
#	/etc/fstab
#	/etc/postfix/main.cf
#	/usr/local/platform/backup/bin/commonbackup_oracle_full_back.sh
#	/usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh
#	/opt/oracle/backup/scripts/rman_backup_arch.ksh
#	/opt/oracle/backup/scripts/rman_backup.ksh
# if the system is a CMS DB or CMS RM, the oracle database will be placed into archive mode
#
# Information required before running script
#	IP or Hostname of NFS server
#	Location on NFS Server for mounting
#	Local mount point for NFS sharing (does not need to exist prior to running this script)
#	Email relayhost 
#	Local IP Address 
#	Valid Email Address
#	Database servers will need to know the length of the data retention desired
#

#### Configuration file modification #############
BACKUP_CONFIG=/usr/local/platform/backup/conf/commonbackup.cfg
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
TMP_FILE=/tmp/backupinfo.conf
for f in ${CONFIG_FILE} ${VAR_FILE} ${BACKUP_CONFIG} ${TMP_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done


###################################################

sed -i "s/BAK_ADMIN=${BAK_ADMIN}/BAK_ADMIN=${EMAIL}/" ${BACKUP_CONFIG}
echo "relayhost=${relayhost}" >> /etc/postfix/main.cf
service postfix restart
chkconfig postfix on
sed -i "s|SAN=${SAN}|SAN=${BACKUP_LOC}|" ${BACKUP_CONFIG}
sed -i "s/M_IFCONFIG=${M_IFCONFIG}/M_IFCONFIG=${IPADDR}/" ${BACKUP_CONFIG}
backupscriptmod () {
	sed -i "s|apps|$APP|g" /usr/local/platform/backup/bin/commonbackup_oracle_full_back.sh
        sed -i "s|apps|$APP|g" /usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh
	cat /home/cmsstaging/conf/cbfullcron >> /var/spool/cron/root
}
nooracle () {
	omitoracle="su - oracle -c /opt/oracle/backup/scripts/rman_backup.ksh DISK"
	sed -i "s|${omitoracle}||g" /usr/local/platform/backup/bin/commonbackup_oracle_full_back.sh
        sed -i "s|${omitoracle}||g" /usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh
	sed -i "s|apps_files.txt apps_rman_full.txt|apps_files.txt|g" /usr/local/platform/backup/bin/commonbackup_oracle_full_back.sh
        sed -i "s|apps_files.txt apps_rman_full.txt|apps_files.txt|g" /usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh
	cat /home/cmsstaging/conf/cbinccron >> /var/spool/cron/root
}

if [ ${CMSTYPE} -eq 1 ]; then
	nooracle
	backupscriptmod
elif [ ${CMSTYPE} -eq 2 ]; then
	backupscriptmod
elif [ ${CMSTYPE} -eq 3 ]; then
	backupscriptmod
elif [ ${CMSTYPE} -eq 4 ]; then
	nooracle
	backupscriptmod
else
	echo "Not a valid Application for cmsbackup"
fi

sed -i "s/CB_APP=${CB_APP}/CB_APP=${APP}/" ${BACKUP_CONFIG}

exit 0

