#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

# copy original files
cp /etc/sysconfig/clock /etc/sysconfig/clock.og
cp /etc/ntp.conf /etc/ntp.conf.og
cp /etc/localtime /etc/localtime.og
cp /etc/hosts /etc/hosts.og
ls /etc/ | grep localtime
ls /etc/ | grep hosts
ls /etc/ | grep ntp
cp /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf.og
ls /etc/snmp/

# Default service configurations
chkconfig ntpd on
chkconfig ntpdate on
chkconfig | grep ntpd
chkconfig nfs on
chkconfig nfs --list

ALIAS=`grep CMSHOSTNAME ${CONFIG_FILE} | cut -f2 -d'=' | cut -f2 -d'.'`
if [ -n ${ALIAS} ] ; then
	ALIAS=`grep CMSHOSTNAME ${CONFIG_FILE} | cut -f2 -d'=' | cut -f1 -d'.'`		
else
	ALIAS=""
fi

## App Appliance
if [ ${CMSTYPE} -eq 1 ] ; then
	# configure App hosts file	
	if ls /tmp/flags/all > /dev/null ; then
		sh ${SCRIPT}/networksetup.sh
		sh ${SCRIPT}/snmpsetup.sh
		sh ${SCRIPT}/ntpsetup.sh
		sh ${SCRIPT}/commonbackup_setup.sh
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		sed -i 's/127.0.0.1 localhost Alerts/#127.0.0.1 localhost Alerts AlertNameServer AlertSettingsService /' /etc/hosts
		echo "${IPADDR}	${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
		echo "${DBIP}	dbserver" >> /etc/hosts
		echo "${IPADDR}	Alerts AlertNameServer AlertSettingsService" >> /etc/hosts
		echo "${IPADDR}  	watchpoint-app" >> /etc/hosts
		echo "${IPADDR}   ACSServer" >> /etc/hosts
		chmod -R 777 /content/uploaded
		chmod +x /usr/local/tstv/Common/scripts/*.pyc
		iptables -t nat -A PREROUTING -p tcp --dport 80 -j REDIRECT --to-port 8080
		iptables -t nat -A PREROUTING -p tcp --dport 443 -j REDIRECT --to-port 8443
		service iptables save
		chkconfig iptables on
		service iptables start
		iptables -L -v -t nat
		chkconfig xportmanager on
		chkconfig xporttomcat on
		chkconfig rmserver on
		chkconfig rcssnmpsubagent on
		chkconfig RCSSchedulerService on
		chkconfig cms on
		chkconfig alerts on
		chkconfig tomcat on
	elif  ls /tmp/flags/network > /dev/null ; then
		sh ${SCRIPT}/networksetup.sh
		sh ${SCRIPT}/commonbackup_setup.sh
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		sed -i 's/127.0.0.1 localhost Alerts/#127.0.0.1 localhost Alerts AlertNameServer AlertSettingsService /' /etc/hosts
		echo "${IPADDR}	${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
		echo "${DBIP}	dbserver" >> /etc/hosts
		echo "${IPADDR}	Alerts AlertNameServer AlertSettingsService" >> /etc/hosts
		echo "${IPADDR}  	watchpoint-app" >> /etc/hosts
		echo "${IPADDR}   ACSServer" >> /etc/hosts
	elif ls /tmp/flags/monitor > /dev/null ; then
		sh ${SCRIPT}/snmpsetup.sh
	elif ls /tmp/flags/ntp > /dev/null ; then
		sh ${SCRIPT}/ntpsetup.sh
	elif ls /tmp/flags/commonbackup > /dev/null ; then
		sh ${SCRIPT}/commonbackup_setup.sh
	elif ls /tmp/flags/appdb > /dev/null ; then
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		sed -i 's/127.0.0.1 localhost Alerts/#127.0.0.1 localhost Alerts AlertNameServer AlertSettingsService /' /etc/hosts
		echo "${IPADDR}	${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
		echo "${DBIP}	dbserver" >> /etc/hosts
		echo "${IPADDR}	Alerts AlertNameServer AlertSettingsService" >> /etc/hosts
		echo "${IPADDR}  	watchpoint-app" >> /etc/hosts
		echo "${IPADDR}   ACSServer" >> /etc/hosts
	else
		echo ""
	fi	
	
## DB Appliance
elif [ ${CMSTYPE} -eq 2 ] ; then
	echo "DB Appliance"
	if ls /tmp/flags/all > /dev/null ; then
		sh ${SCRIPT}/networksetup.sh
		sh ${SCRIPT}/snmpsetup.sh
		sh ${SCRIPT}/ntpsetup.sh
		sh ${SCRIPT}/commonbackup_setup.sh
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		sed -i 's/127.0.0.1	localhost.localdomain/#127.0.0.1	localhost.localdomain/' /etc/hosts
		echo "${IPADDR}   ${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
		service oracle stop
		sleep 5
		service oracle start
		sleep 10
		su - oracle -c "cd /home/oracle/scripts/install/installcms;sh installCMS.sh"
		su - oracle -c "cd /home/oracle/scripts/install/installrcs;sh installRCS.sh"
		su - oracle -c "cd /home/oracle/scripts/install/installepgmgr;sh installepgmgr.sh"
		su - oracle -c "cd /home/oracle/scripts/install/installdw;sh installDW.sh"
		crontab -l -u oracle
		cp /home/cmsstaging/bin/RCSTimezone.sh /home/oracle/
		chown oracle:oinstall /home/oracle/RCSTimezone.sh
		su - oracle -c "/home/oracle/RCSTimezone.sh"
	elif  ls /tmp/flags/network > /dev/null ; then
		sh ${SCRIPT}/networksetup.sh
		sh ${SCRIPT}/commonbackup_setup.sh
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		sed -i 's/127.0.0.1	localhost.localdomain/#127.0.0.1	localhost.localdomain/' /etc/hosts
		echo "${IPADDR}   ${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
		service oracle stop
		sleep 5
		service oracle start
		sleep 60
	elif ls /tmp/flags/monitor > /dev/null ; then
		sh ${SCRIPT}/snmpsetup.sh
	elif ls /tmp/flags/ntp > /dev/null ; then
		sh ${SCRIPT}/ntpsetup.sh
	elif ls /tmp/flags/commonbackup > /dev/null ; then
		sh ${SCRIPT}/commonbackup_setup.sh
	else
		echo ""
	fi	
	
## RM Appliance
elif [ ${CMSTYPE} -eq 3 ] ; then
	echo "RM Appliance"
	if ls /tmp/flags/all > /dev/null ; then
		sh ${SCRIPT}/networksetup.sh
		sh ${SCRIPT}/snmpsetup.sh
		sh ${SCRIPT}/ntpsetup.sh
		sh ${SCRIPT}/commonbackup_setup.sh
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		sed -i 's/127.0.0.1		localhost.localdomain/#127.0.0.1	localhost.localdomain/' /etc/hosts
        echo "${IPADDR}   ${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
        echo "${IPADDR}   NotificationServer TSTVNameServer" >> /etc/hosts
        echo "${IPADDR}   dbserver" >> /etc/hosts
        sh ${SCRIPT}/rmsetup.sh	
		sh ${SCRIPT}/backofficesetup.sh
		sh ${SCRIPT}/rmrtcsetup.sh	
		iptables -t nat -A PREROUTING -p tcp --dport 80 -j REDIRECT --to-port 8080
        	iptables -t nat -A PREROUTING -p tcp --dport 443 -j REDIRECT --to-port 8443
        	service iptables save
        	chkconfig iptables on
        	service iptables start
        	iptables -L -v -t nat
		chkconfig jboss on
		chkconfig rmscheduler on
		x=`grep CONSTORE ${CONFIG_FILE} | wc -l`
		if [ ${x} -gt 0 ] ; then
			chkconfig CORBAnameservice on
			chkconfig CORBAnotificationservice on
		fi
	elif  ls /tmp/flags/network > /dev/null ; then
		sh ${SCRIPT}/networksetup.sh
		sh ${SCRIPT}/commonbackup_setup.sh
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		sed -i 's/127.0.0.1		localhost.localdomain/#127.0.0.1	localhost.localdomain/' /etc/hosts
        	echo "${IPADDR}   ${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
        	echo "${IPADDR}   NotificationServer TSTVNameServer" >> /etc/hosts
        	echo "${IPADDR}   dbserver" >> /etc/hosts
        	sed -i "s/4f0d616cd88a9ba8:-1218ec64ce9860fb@<IP OF RM AS SEEN FROM DOWNSTREAM SYSTEM>/${FTPNAME}:${FTPPASSWORD}@${IPADDR}/" /usr/local/tstv/RMScheduler/config/rmScheduler.properties
        	sed -i "s/<RM WEB IP ADDRESS>/${IPADDR}/" /usr/local/tstv/RMScheduler/config/rmScheduler.properties
        	sed -i "s/<IP_Address_of_RM>/${IPADDR}/" /usr/local/tstv/jboss/server/default/deploy/RMWeb.war/WEB-INF/classes/RMWebConfig.properties
	elif ls /tmp/flags/monitor > /dev/null ; then
		sh ${SCRIPT}/snmpsetup.sh
	elif ls /tmp/flags/ntp > /dev/null ; then
		sh ${SCRIPT}/ntpsetup.sh
	elif ls /tmp/flags/commonbackup > /dev/null ; then
		sh ${SCRIPT}/commonbackup_setup.sh
	elif ls /tmp/flags/backoffice > /dev/null ; then
		sh ${SCRIPT}/backofficesetup.sh
	elif ls /tmp/flags/rmrtc > /dev/null ; then
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		sed -i 's/127.0.0.1		localhost.localdomain/#127.0.0.1	localhost.localdomain/' /etc/hosts
        	echo "${IPADDR}   ${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
        	echo "${IPADDR}   NotificationServer TSTVNameServer" >> /etc/hosts
        	echo "${IPADDR}   dbserver" >> /etc/hosts
		sh ${SCRIPT}/rmrtcsetup.sh
	elif ls /tmp/flags/ftpuser > /dev/null ; then
		sed -i "s/4f0d616cd88a9ba8:-1218ec64ce9860fb@<IP OF RM AS SEEN FROM DOWNSTREAM SYSTEM>/${FTPNAME}:${FTPPASSWORD}@${IPADDR}/" /usr/local/tstv/RMScheduler/config/rmScheduler.properties
	else
		echo ""
	fi	
	
## RTC Appliance
elif [ ${CMSTYPE} -eq 4 ] ; then
	echo "RTC Appliance"
	if ls /tmp/flags/all > /dev/null ; then
		sh ${SCRIPT}/networksetup.sh
		sh ${SCRIPT}/snmpsetup.sh
		sh ${SCRIPT}/ntpsetup.sh
		sh ${SCRIPT}/commonbackup_setup.sh
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		echo "${IPADDR}   ${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
		sed -i "s/4f0d616cd88a9ba8:-1218ec64ce9860fb@<RTC Ip Address> /${FTPNAME}:${FTPPASSWORD}@${IPADDR}/" /usr/local/tstv/rtc/config/RTCConfiguration.properties
		sh ${SCRIPT}/rtcsetup.sh
		chkconfig rtc on
	elif  ls /tmp/flags/network > /dev/null ; then
		sh ${SCRIPT}/networksetup.sh
		sh ${SCRIPT}/commonbackup_setup.sh
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		echo "${IPADDR}   ${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
		sed -i "s/4f0d616cd88a9ba8:-1218ec64ce9860fb@<RTC Ip Address> /${FTPNAME}:${FTPPASSWORD}@${IPADDR}/" /usr/local/tstv/rtc/config/RTCConfiguration.properties
		sh ${SCRIPT}/rtcsetup.sh
	elif ls /tmp/flags/monitor > /dev/null ; then
		sh ${SCRIPT}/snmpsetup.sh
	elif ls /tmp/flags/ntp > /dev/null ; then
		sh ${SCRIPT}/ntpsetup.sh
	elif ls /tmp/flags/commonbackup > /dev/null ; then
		sh ${SCRIPT}/commonbackup_setup.sh
	elif ls /tmp/flags/rtc > /dev/null ; then
		cp /etc/hosts /etc/hosts+`date +%d-%m-%y_%H%M`
		cp /etc/hosts.og /etc/hosts
		echo "${IPADDR}   ${CMSHOSTNAME} ${ALIAS}" >> /etc/hosts
		sed -i "s/4f0d616cd88a9ba8:-1218ec64ce9860fb@<RTC Ip Address> /${FTPNAME}:${FTPPASSWORD}@${IPADDR}/" /usr/local/tstv/rtc/config/RTCConfiguration.properties
		sh ${SCRIPT}/rtcsetup.sh
	elif ls /tmp/flags/ftpuser > /dev/null ; then
		sed -i "s/4f0d616cd88a9ba8:-1218ec64ce9860fb@<RTC Ip Address> /${FTPNAME}:${FTPPASSWORD}@${IPADDR}/" /usr/local/tstv/rtc/config/RTCConfiguration.properties
	else
		echo ""
	fi		
	
else
	echo
fi



exit 0
