#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

k=0
for i in $(ls /sys/class/net/ | grep eth) ; do
	j=`ifconfig ${i} | grep 'TX packets:' | cut -f2 -d':' | cut -f1 -d'e'`
	if [ ${j} -gt 0 ] ; then
		eth[${k}]=${i}
	fi
	k=${k}+1		
done

for element in "${eth[@]}" ; do
	echo $element >> /tmp/ethinfo.conf
done

cont=n
while [ ${cont} = n ] ; do
	echo " "
	device=0
	j=1
	for i in $(more /tmp/ethinfo.conf ) ; do
		echo "${j}.  ${i}  "
		j=`expr ${j} + 1`
	done
	echo "select the number next to the device you would like to configure:  "
	read device
	echo " "
	dev=`head -${device} /tmp/ethinfo.conf | tail -1`
	echo " "
	read -p "What is the IP Address?  " ip
	echo " "
	read -p "What is the Subnet Mask?  " mask
	echo " "
	contype=0
	while [ ${contype} -eq 0 ] ; do
		read -p "Is this IP Address to be used as the management connnection?  " data
		echo " "
		data=${data:-y}
		case ${data} in
			"y"|"Y"|"yes"|"Yes")
				echo "device=${dev}" >> /tmp/networkinfo.conf
				echo "DATAIPADDR${dev}=${ip}" >> /tmp/networkinfo.conf
				echo "MASK${dev}=${mask}" >> /tmp/networkinfo.conf
				read -p "What is the hostname of the system? [${CMSHOSTNAME}]  " tmpCMSHOSTNAME
				tmpCMSHOSTNAME=${tmpCMSHOSTNAME:-${CMSHOSTNAME}}
				echo "CMSHOSTNAME=${CMSHOSTNAME}" >> /tmp/networkinfo.conf
				echo " "
				read -p "What is the system Gateway address? " tmpGATEWAY
				echo "GATEWAY=${tmpGATEWAY}"  >> /tmp/networkinfo.conf
				echo " "
				read -p "What is the primary dns address? " tmpPRINAMESERVER
				echo "PRINAMESERVER=${tmpPRINAMESERVER}" >> /tmp/networkinfo.conf
				echo " "
				read -p "What is the secondary dns address?  " tmpSECNAMESERVER
				echo "SECNAMESERVER=${tmpSECNAMESERVER}" >> /tmp/networkinfo.conf
				echo " "
				read -p "What is the domain search path?  "  tmpDOMSEARCH
				echo "DOMSEARCH=${tmpDOMSEARCH}" >> /tmp/networkinfo.conf
				contype=1
				;;
			"n"|"N"|"no"|"No")
				echo " "
				echo "device=${dev}" >> /tmp/networkinfo.conf
                		echo "IPADDR${dev}=${ip}" >> /tmp/networkinfo.conf
                		echo "MASK${dev}=${mask}" >> /tmp/networkinfo.conf
				contype=1
				;;
			*)
				echo " "
				contype=0
				;;
		esac
	done
	another=0
	while [ ${another} -eq 0 ] ; do
		echo " "
		read -p "Would you like to configure another device?  " moredev
                case ${moredev} in
			"y"|"Y"|"yes"|"Yes")
				another=1
                                cont=n
				;;
                        "n"|"N"|"no"|"No")
				cat /tmp/networkinfo.conf
                		read -p "Is this correct?  " correct
				case ${correct} in
					"y"|"Y"|"yes"|"Yes")
						another=1
						cont=y
						;;
					*)
						another=1
						cont=n
						;;
				esac
				;;
                        *)
				echo " "
				another=0
				;;
		esac

	done
done

## copy data
tmpDATAIP=`grep DATAIPADDR /tmp/networkinfo.conf | cut -f2 -d'='`
tmpHOSTNAME=`grep CMSHOSTNAME /tmp/networkinfo.conf | cut -f2 -d'='`
sed -i "s/IPADDR=${IPADDR}/IPADDR=${tmpDATAIP}/" ${CONFIG_FILE}
sed -i "s/CMSHOSTNAME=${CMSHOSTNAME}/CMSHOSTNAME=${tmpCMSHOSTNAME}/" ${CONFIG_FILE}
cp /tmp/networkinfo.conf /home/cmsstaging/conf/networkinfo.conf

## clean up
#rm /tmp/ethinfo.conf
#rm /tmp/networkinfo.conf

exit 0
