#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
NETCONF_FILE=/home/cmsstaging/conf/networkinfo.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${NETCONF_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

service network stop

for i in $(grep IPADDR ${NETCONF_FILE} | cut -f2 -d'R' | cut -f1 -d'=' | cut -f2 -d'h') ; do
	devicename=`grep IPADDReth${i} ${NETCONF_FILE} | cut -f2 -d'R' | cut -f1 -d'='`
	echo ${devicename}

	case ${devicename} in
		"eth0")
			IP=`grep IPADDR${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
			MASK=`grep MASK${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
			echo "IPADDR=${IP}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
			echo "NETMASK=${MASK}"  >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
			;;
		"eth1")
                	IP=`grep IPADDR${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	MASK=`grep MASK${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	echo "IPADDR=${IP}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	echo "NETMASK=${MASK}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	;;
		"eth2")
                	IP=`grep IPADDR${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	MASK=`grep MASK${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	echo "IPADDR=${IP}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	echo "NETMASK=${MASK}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	;;
		"eth3")
                	IP=`grep IPADDR${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	MASK=`grep MASK${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	echo "IPADDR=${IP}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	echo "NETMASK=${MASK}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	;;
		"eth4")
                	IP=`grep IPADDR${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	MASK=`grep MASK${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	echo "IPADDR=${IP}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	echo "NETMASK=${MASK}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	;;
		"eth5")
                	IP=`grep IPADDR${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	MASK=`grep MASK${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	echo "IPADDR=${IP}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	echo "NETMASK=${MASK}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	;;
		"eth6")
                	IP=`grep IPADDR${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	MASK=`grep MASK${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	echo "IPADDR=${IP}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	echo "NETMASK=${MASK}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	;;
		"eth7")
                	IP=`grep IPADDR${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	MASK=`grep MASK${devicename} ${NETCONF_FILE} | cut -f2 -d'='`
                	echo "IPADDR=${IP}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	echo "NETMASK=${MASK}" >> /etc/sysconfig/network-scripts/ifcfg-${devicename}
                	;;
		*)
			echo "not an option"
			;;
	esac

done

sed -i "s/HOSTNAME=${HOSTNAME}/HOSTNAME=${CMSHOSTNAME}/" /etc/sysconfig/network
echo "GATEWAY=${GATEWAY}" >> /etc/sysconfig/network
echo "nameserver ${PRINAMESERVER}" >> /etc/resolv.conf
echo "nameserver ${SECNAMESERVER}" >> /etc/resolv.conf
echo "search ${DOMSEARCH}" >> /etc/resolv.conf

service network start

exit 0
