#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

cont=n
while [ ${cont} = n ] ; do
	echo " "
	read -p "Enter new IP or Host for network time synchronization [${NTPHOST}]?  " tmpntp
	tmpntp=${tmpntp:-${NTPHOST}}
	echo "NTPHOST=${tmpntp}" > /tmp/ntpinfo.conf
	echo " "
	read -p "Please confirm ntp host is:  ${tmpntp}  " newntp
	newntp=${newntp:-n}
	case ${newntp} in
		"y"|"Y"|"yes"|"Yes")
			sed -i "s/NTPHOST=${NTPHOST}/NTPHOST=${tmpntp}/" ${CONFIG_FILE}
			cont=y
			;;
		*)
			cont=n
			;;
	esac
done

# cleanup temp directories
#rm /tmp/ntpinfo.conf

exit 0
