#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

read -p "How many Capture devices will be used with this RM? [1] " tmpRTCCOUNT
tmpRTCCOUNT=${tmpRTCCOUNT:-1}
echo "RTCCOUNT=${tmpRTCCOUNT}" >> /tmp/rtcinfo.conf
for (( z=1; z<=${tmpRTCCOUNT}; z++ ));
do
    tmpRTCTYPE=0
	echo "1.  Ericsson RTC"
	echo "2.  Concurrent Media Hawk"
	echo "3.  Microsoft R-Server"
	echo -n "Select the type of Capture Device from the list above [1, 2, 3]:  "
	read tmpRTCTYPE
        
	echo "RTCTYPE_${z}=${tmpRTCTYPE}" >> /tmp/rtcinfo.conf
   	if [ ${tmpRTCTYPE} -eq 1 ] ; then
            read -p "What is the IP Address of the RTC system to be used?  " tmpRTCIP
            read -p "Provide the name server Content Store Factory Name: [RTCFactory]  " tmpFACNAME
            tmpFACNAME=${tmpFACNAME:-RTCFactory}
            read -p "Provide the name server Content Store Name: [RTCStore]  " tmpCONSTORE
            tmpCONSTORE=${tmpCONSTORE:-RTCStore}
            read -p "Provide the name server IIOP HOST Name: [RTCContent]  " tmpOPHOST
            tmpOPHOST=${tmpOPHOST:-RTCContent}
            echo "RTCIP_${z}=${tmpRTCIP}" >> /tmp/rtcinfo.conf
			echo "FACNAME_${z}=${tmpFACNAME}" >> /tmp/rtcinfo.conf
			echo "CONSTORE_${z}=${tmpCONSTORE}" >> /tmp/rtcinfo.conf
			echo "OPHOST_${z}=${tmpOPHOST}" >> /tmp/rtcinfo.conf
	elif [ ${tmpRTCTYPE} -eq 2 ] ; then
         	read -p "What is the IP Address of the Concurrent Media Hawk system to be used?  " tmpRTCIP
            read -p "Provide the name of the Extended Content Store Factory Name: [ConcurrentContentStoreFactory]  " tmpFACNAME 
            tmpFACNAME=${tmpFACNAME:-ConcurrentContentStoreFactory}
            read -p "Provide the name of the Content Name: [RTCContent]  " tmpOPHOST
            tmpOPHOST=${tmpOPHOST:-RTCContent}
            echo "RTCIP_${z}=${tmpRTCIP}" >> /tmp/rtcinfo.conf
            echo "FACNAME_${z}=${tmpFACNAME}" >> /tmp/rtcinfo.conf
            echo "OPHOST_${z}=${tmpOPHOST}" >> /tmp/rtcinfo.conf
   	elif [ ${tmpRTCTYPE} -eq 3 ] ; then
            read -p "Provide the Microsoft R-Server NAS username:  " l2vname
            /usr/local/tstv/Common/pwdtool/scripts/passwordgen.sh ${l2vname} > /root/test.txt
            l2vname=`cat /root/test.txt | grep 'Encoded password' | cut -f2 -d':'`
            read -p "Provide the Microsoft R-Server NAS password:  " l2vpassword
            /usr/local/tstv/Common/pwdtool/scripts/passwordgen.sh ${l2vpassword} > /root/test.txt
            l2vpassword=`cat /root/test.txt | grep 'Encoded password' | cut -f2 -d':'`
            echo "L2VNAME_${z}=${l2vname}" >> /tmp/rtcinfo.conf
			echo "L2VPASSWORD_${z}=${l2vpassword}" >> /tmp/rtcinfo.conf
			rm /root/test.txt
   	else
		tmpRTCTYPE=0
	fi
done

for i in $(more /tmp/rtcinfo.conf) ; do
	echo "${i}" >> ${CONFIG_FILE}
done

# cleanup temp files
#rm /tmp/rtcinfo.conf

exit 0
