#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
SCHED_CONFIG=/usr/local/tstv/RMScheduler/config/rmScheduler.properties
WEB_CONFIG=/usr/local/tstv/jboss/server/default/deploy/RMWeb.war/WEB-INF/classes/RMWebConfig.properties
for f in ${CONFIG_FILE} ${VAR_FILE} ${SCHED_CONFIG} ${WEB_CONFIG}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

## RMScheduler Config
ftpuser=${FTP_USER}
ftppass=${FTP_USER_PASSWORD}
rmip=${RM_IP}
ftpport=${FTP_PORT}
ftppath=${FTP_USER_DATA_PATH}
webip=`grep RM_WEB_IP_ADDRESS= ${SCHED_CONFIG} | cut -f2 -d'='`

sed -i "s/FTP_USER=${ftpuser}/FTP_USER=${FTPNAME}/" ${SCHED_CONFIG}
sed -i "s/FTP_USER_PASSWORD=${ftppass}/FTP_USER_PASSWORD=${FTPPASSWORD}/" ${SCHED_CONFIG}
sed -i "s/RM_IP=${rmip}/RM_IP=${IPADDR}/" ${SCHED_CONFIG}
sed -i "s/FTP_PORT=${ftpport}/FTP_PORT=${FTPPORT}/" ${SCHED_CONFIG}
sed -i "s|FTP_USER_DATA_PATH=${ftppath}|FTP_USER_DATA_PATH=${RMFTPDATAPATH}|" ${SCHED_CONFIG}
sed -i "s/RM_WEB_IP_ADDRESS=${webip}/RM_WEB_IP_ADDRESS=${IPADDR}/" ${SCHED_CONFIG}
echo "FTP_PROVISIONING_PATH=ftp://${FTPNAME}:${FTPPASSWORD}@${IPADDR}:${FTPPORT}${RMFTPDATAPATH}" >> ${SCHED_CONFIG}

## RMWeb Config
webip=`grep RM_WEB_IP_ADDRESS= ${WEB_CONFIG}
sed -i "s/RM_WEB_IP_ADDRESS=${webip}/RM_WEB_IP_ADDRESS=${IPADDR}/" ${WEB_CONFIG}

exit 0