#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

cont=n
while [ ${cont} = n ] ; do
	read -p "Provide the name server Content Store Factory Name: [${FACTORY}]  " tmpFACTORY
	tmpFACTORY=${tmpFACTORY:-${FACTORY}}
	echo "FACTORY=${tmpFACTORY}" > /tmp/rtcinfo.conf
	read -p "Provide the name server Content Store Name: [${CONTENTSTORE}]  " tmpCONTENTSTORE
	tmpCONTENTSTORE=${tmpCONTENTSTORE:-${CONTENTSTORE}}
	echo "CONTENTSTORE=${tmpCONTENTSTORE}" >> /tmp/rtcinfo.conf
	read -p "Provide the name server Extented Content Store Name: [${EXTCONTENTSTORE}]  " tmpEXTCONTENTSTORE
	tmpEXTCONTENTSTORE=${tmpEXTCONTENTSTORE:-${EXTCONTENTSTORE}}
	echo "EXTCONTENTSTORE=${tmpEXTCONTENTSTORE}" >> /tmp/rtcinfo.conf
	read -p "Provide the name server IIOP HOST Name: [${IIOPHOST}]  " tmpIIOPHOST
	tmpIIOPHOST=${tmpIIOPHOST:-${IIOPHOST}}
	echo "IIOPHOST=${tmpIIOPHOST}" >> /tmp/rtcinfo.conf
	read -p "Provide the name server IIOP Port number: [${IIOPPORT}]  " tmpIIOPPORT
	tmpIIOPPORT=${tmpIIOPPORT:-${IIOPPORT}}
	echo "IIOPPORT=${tmpIIOPPORT}" >> /tmp/rtcinfo.conf
	echo "The following three questions should be answered in terms of GB"
	echo "Please only supply numberic values"
	read -p "Provide allocated Disk Space for Extended Content Store: [${EXTCSDISKSPACE}]  " tmpEXTCSDISKSPACE
	tmpEXTCSDISKSPACE=${tmpEXTCSDISKSPACE:-${EXTCSDISKSPACE}}
	echo "EXTCSDISKSPACE=${tmpEXTCSDISKSPACE}" >> /tmp/rtcinfo.conf
	read -p "Provide Disk Usage Threshold Percentage:  [${THRESHPERCENT}]  " tmpTHRESHPERCENT
	tmpTHRESHPERCENT=${tmpTHRESHPERCENT:-${THRESHPERCENT}}
	echo "THRESHPERCENT=${tmpTHRESHPERCENT}" >> /tmp/rtcinfo.conf
	read -p "Provide Disk Usage Threshold Percentage after the cleanup is run:  [${CLEANTHRESHPERCENT}]  " tmpCLEANTHRESHPERCENT
	tmpCLEANTHRESHPERCENT=${tmpCLEANTHRESHPERCENT:-${CLEANTHRESHPERCENT}}
	echo "CLEANTHRESHPERCENT=${tmpCLEANTHRESHPERCENT}" >> /tmp/rtcinfo.conf
	read -p "What is the IP Address of the RM system to be used? [${RMIP}] " tmpRMIP
	tmpRMIP=${tmpRMIP:-${RMIP}}
	echo "RMIP=${tmpRMIP}" >> /tmp/rtcinfo.conf

	more /tmp/rtcinfo.conf
	read -p "Is the above information correct?  " correct
	case ${correct} in
		"y"|"Y"|"yes"|"Yes")
			sed -i "s/FACTORY=${FACTORY}/FACTORY=${tmpFACTORY}/" ${CONFIG_FILE}
			sed -i "s/CONTENTSTORE=${CONTENTSTORE}/CONTENTSTORE=${tmpCONTENTSTORE}/" ${CONFIG_FILE}
			sed -i "s/EXTCONTENTSTORE=${EXTCONTENTSTORE}/EXTCONTENTSTORE=${tmpEXTCONTENTSTORE}/" ${CONFIG_FILE}
			sed -i "s/IIOPHOST=${IIOPHOST}/IIOPHOST=${tmpIIOPHOST}/" ${CONFIG_FILE}
			sed -i "s/IIOPPORT=${IIOPPORT}/IIOPPORT=${tmpIIOPPORT}/" ${CONFIG_FILE}
			sed -i "s/EXTCSDISKSPACE=${EXTCSDISKSPACE}/EXTCSDISKSPACE=${tmpEXTCSDISKSPACE}/" ${CONFIG_FILE}
			sed -i "s/THRESHPERCENT=${THRESHPERCENT}/THRESHPERCENT=${tmpTHRESHPERCENT}/" ${CONFIG_FILE}
			sed -i "s/CLEANTHRESHPERCENT=${CLEANTHRESHPERCENT}/CLEANTHRESHPERCENT=${tmpCLEANTHRESHPERCENT}/" ${CONFIG_FILE}
			sed -i "s/RMIP=${RMIP}/RMIP=${tmpRMIP}/" ${CONFIG_FILE}
			cont=y
			;;
		*)
			cont=n
			;;
	esac
	
done

# cleanup files
#rm /tmp/rtcinfo.conf

exit 0
