#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
RTC_CONFIG=/usr/local/tstv/rtc/config/RTCConfiguration.properties
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

sed -i "s/RTCFactory/${FACTORY}/" ${RTC_CONFIG}
sed -i "s/RTCStore/${CONTENTSTORE}/" ${RTC_CONFIG}
sed -i "s/ExtendedContentStoreChannel/${EXTCONTENTSTORE}/" ${RTC_CONFIG}
sed -i "s/RTCContent/${IIOPHOST}/" ${RTC_CONFIG}
sed -i "s/42190/${IIOPPORT}/" ${RTC_CONFIG}
sed -i "s/500/${EXTCSDISKSPACE}/" ${RTC_CONFIG}
sed -i "s/=90/=${THRESHPERCENT}/" ${RTC_CONFIG}
sed -i "s/85/${CLEANTHRESHPERCENT}/" ${RTC_CONFIG}
echo "com.ttv.rtc.Capture.ftpURL=ftp://${FTPNAME}:${FTPPASSWORD}@${IPADDR}:${FTPPORT}${RTCFTPDATAPATH}/"  >> ${RTC_CONFIG}
echo "${IPADDR}   ${FACTORY} ${CONTENTSTORE} ${IIOPHOST}" >> /etc/hosts
echo "${RMIP}     NameServer NotificationServer SettingsServer NameService Alerts TSTVNameServer" >> /etc/hosts


exit 0

