#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

cont=n
while [ ${cont} = n ] ; do
	if [ ${CMSTYPE} -eq 1 ] ; then 
		read -p "Will Recording Module be used on this system?  " tmprcs
		tmprcs=${tmprcs:-${RCS}}
		echo "RCS=${tmprcs}" > /tmp/monitoringinfo.conf
		case ${tmprcs} in
			"y"|"Y"|"yes"|"Yes")
				read -p "Will nCompass be used for Recording event notification?  " tmpncompass
                                tmpncompass=${tmpncompass:-${NCOMPASS}}
                                echo "NCOMPASS=${tmpncompass}" >> /tmp/monitoringinfo.conf
				case ${tmpncompass} in
					"y"|"Y"|"yes"|"Yes")
						read -p "What is the IP of the nCompass Server? [${NCOMPASSIP}] " tmpncompassIP
                                        	echo "NCOMPASSIP=${tmpncompassIP}" >> /tmp/monitoringinfo.conf
                                        	read -p "What is the Port number to be used with nCompass Server? [${NCOMPASSPORT}] " tmpncompassPORT
                                        	tmpncompassPORT=${tmpncompassPORT:-${NCOMPASSPORT}}
                                        	echo "NCOMPASSPORT=${tmpncompassPORT}" >> /tmp/monitoringinfo.conf
						;;
					*)
						;;
				esac
				;;
			*)
				;;
			esac
		read -p "Will CMS Alerts be used on this system? " tmpalerts
		tmpalerts=${tmpalerts:-${ALERTS}}
		echo "ALERTS=${tmpalerts}" >> /tmp/monitoringinfo.conf
		case ${tmpalerts} in
			"y"|"Y"|"yes"|"Yes")
				read -p "Enter IP for snmp traps [${SNMPIP}]?  " tmpsnmpip
                		tmpsnmpip=${tmpsnmpip:-${SNMPIP}}
                		echo "SNMPIP=${tmpsnmpip}" >> /tmp/monitoringinfo.conf
				read -p "Enter IP for email server [${SMTPIP}]?  " tmpsmtpip
                        	tmpsmtpip=${tmpsmtpip:-${SMTPIP}}
                        	echo "SMTPIP=${tmpsmtpip}" >> /tmp/monitoringinfo.conf
				;;
			*)
				;;
		esac
		cat /tmp/monitoringinfo.conf
		read -p " Please confirm the above information is correct?  " correct
		correct=${correct:-n}
		case ${correct} in
			"y"|"Y"|"yes"|"Yes")
				sed -i "s/RCS=${RCS}/RCS=${tmprcs}/" ${CONFIG_FILE}
				sed -i "s/NCOMPASS=${NCOMPASS}/NCOMPASS=${tmpncompass}/" ${CONFIG_FILE}
				sed -i "s/NCOMPASSIP=${NCOMPASSIP}/NCOMPASSIP=${tmpncompassIP}/" ${CONFIG_FILE}
				sed -i "s/NCOMPASSPORT=${NCOMPASSPORT}/NCOMPASSPORT=${tmpncompassPORT}/" ${CONFIG_FILE}
				sed -i "s/SMTPIP=${SMTPIP}/SMTPIP=${tmpsmtpip}/" ${CONFIG_FILE}
				sed -i "s/SNMPIP=${SNMPIP}/SNMPIP=${tmpsnmpip}/" ${CONFIG_FILE}
				sed -i "s/ALERTS=${ALERTS}/ALERTS=${tmpalerts}/" ${CONFIG_FILE}
				cont=y
				;;
			*)
				cont=n
				;;
		esac
	else
		read -p "Enter new IP for snmp traps [${SNMPIP}]?  " tmpsnmpip
	        tmpsnmpip=${tmpsnmpip:-${SNMPIP}}
        	echo "SNMPIP=${tmpsnmpip}" > /tmp/monitoringinfo.conf
	        read -p "Please confirm snmp monitor IP is:  ${tmpsnmpip}  " newsnmp
        	newsnmp=${newsnmp:-n}
	        case ${newsnmp} in
			"y"|"Y"|"yes"|"Yes")
				sed -i "s/SNMPIP=${SNMPIP}/SNMPIP=${tmpsnmpip}/" ${CONFIG_FILE}
                		cont=y
				;;
			*)
				cont=n
				;;
		esac
	fi

done
# cleanup
#rm /tmp/monitoringinfo.conf

exit 0
