#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

service snmpd stop
if [ ${CMSTYPE} -eq 1 ] ; then
        # configure alerts service
	if [ ${ALERTS} = y ] ; then
        	sed -i "s/emailHost=\[SMTP Host IP\]/emailHost=${SMTPIP}/" /usr/local/n2bb/conf/alerts_settings.conf
        	sed -i "s/Destination=\[NMS IP address\]/Destination=${SNMPIP}/" /usr/local/n2bb/conf/alerts_settings.conf
	fi

        if [ ${NCOMPASS} = y ] ; then
                iptables -t nat -D PREROUTING -p udp --dport 161 -j REDIRECT --to-port 1605 
                iptables -t nat -A PREROUTING -p udp --dport 161 -j REDIRECT --to-port 1605
                service iptables save
                chkconfig iptables on
                chkconfig iptables --list
                service iptables start
                iptables -L -v -t nat
                sed -i 's/agentXRetries 2/agentXRetries 2\nagentaddress 1601 /' /etc/snmp/snmpd.conf
                echo "trap2sink ${NCOMPASSIP} public" >> /etc/snmp/snmpd.conf
                cat /etc/snmp/snmpd.conf
                sed -i 's/NMS_NCOMPASS=false/NMS_NCOMPASS=true /' /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties
                sed -i "s/<<ncompass server IP Address>>/${NCOMPASSIP}/" /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties
                sed -i "s/<<ncompass server port>>/${NCOMPASSPORT}/" /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties
                sed -i "s/<<RCS IP as seen by nCompass>>/${IPADDR}/" /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties
                cat /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties
                sed -i 's/NMS_NCOMPASS=false/NMS_NCOMPASS=true /' /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
                sed -i "s/<<ncompass server IP Address>>/${NCOMPASSIP}/" /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
                sed -i "s/<<ncompass server port>>/${NCOMPASSPORT}/" /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
                sed -i "s/<<RCS IP as seen by nCompass>>/${IPADDR}/" /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
                cat /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
	else
                sed -i 's/agentaddress 1601/#agentaddress1601 /' /etc/snmp/snmpd.conf
                echo "trap2sink ${SNMPIP} public" >> /etc/snmp/snmpd.conf
                cat /etc/snmp/snmpd.conf
                sed -i 's/NMS_NCOMPASS=true/NMS_NCOMPASS=false /' /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties
                sed -i "s/<<RCS IP as seen by nCompass>>/${IPADDR}/" /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties
                cat /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
                sed -i 's/NMS_NCOMPASS=true/NMS_NCOMPASS=false /' /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
                sed -i "s/<<RCS IP as seen by nCompass>>/${IPADDR}/" /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
                cat /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties
                iptables -t nat -D PREROUTING -p udp --dport 161 -j REDIRECT --to-port 1605
                service iptables save
                chkconfig iptables off
                chkconfig iptables --list
        	service iptables stop
        fi
else
        echo "trap2sink ${SNMPIP} public" >> /etc/snmp/snmpd.conf
        cat /etc/snmp/snmpd.conf
fi
service snmpd start

exit 0
