#!/bin/bash
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

k=0
for i in $(ls /usr/share/zoneinfo) ; do
        timezone[${k}]=${i}
        k=${k}+1
done

for element in "${timezone[@]}" ; do
        echo $element >> /tmp/timezoneinfo.conf
done

tzs=`ls /usr/share/zoneinfo | wc -l`
tz=1
for ((i=1; i<${tzs}; i++)) ; do
	echo "${i}. ${timezone[${tz}]}"
	tz=`expr ${tz}+1`
done
echo -n "Choose a timezone for the list above? "
read tz 
echo
echo "${tz}"
echo "You have chosen the following timezone ${timezone[$tz]}" 
echo

rm /tmp/timezoneinfo.conf

exit 0
