#!/bin/bash
#
#  script to verify the cms system configuration
#
BACKUP_CONFIG=/usr/local/platform/backup/conf/commonbackup.cfg
CONFIG_FILE=/home/cmsstaging/conf/cmsconfig.conf
VAR_FILE=/home/cmsstaging/conf/setupvars
for f in ${CONFIG_FILE} ${VAR_FILE} ${BACKUP_CONFIG}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done

compare() {
	if [ ${1} = ${2} ] ; then
		echo "items match"
	else
		echo "items do not match, please configure again"
	fi


}

if [ ${CMSTYPE} -eq 1 ] ; then
	echo "App Server"
	echo "Verify License file exists on the system"	
	if ls /opt/tandbergtv/cms/conf/workflow/licensekey.lic > /dev/null ; then
		echo "A CMS license file exists on the system"
	else
		echo "Can not locate CMS license file on the system"
	fi

	echo "Verify DB Address"
	hostsdb=`grep dbserver /etc/hosts | cut -f1 -d' '`
	compare ${hostsdb} ${DBIP}
	
	if [ ${ALERTS} = y ] ; then
		alertsEmail=`grep emailHost /usr/local/n2bb/conf/alerts_settings.conf | cut -f2 -d'='` 
		alertsSnmp=`grep Destination /usr/local/n2bb/conf/alerts_settings.conf | cut -f2 -d'='`
		compare ${alertsEmail} ${SMTPIP}
	fi

        if [ ${NCOMPASS} = y ] ; then
		echo "/usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties nCompass True/False"                
		ncctf=`grep NMS_NCOMPASS /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties | cut -f2 -d'='`
		if [ ${ncctf} = true ] ; then
			echo "nCompass NMS setting in /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties is correct"
		else
			echo "Please configure nCompass settings again"
		fi
		echo "/usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties nCompass IP"
		nccIP=`grep NMS_IP /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties | cut -f2 -d':' | cut -f1 -d'/'`
		compare ${nccIP} ${NCOMPASSIP}
		echo "/usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties nCompass Port"
		nccPort=`grep NMS_IP /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties | cut -f2 -d':' | cut -f1 -d'/'`
		compare ${nccPort} ${NCOMPASSPORT}
		echo "/usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties RCS IP Address"
		rcsIP=`grep agent_URL /usr/local/tstv/RCSScheduler/config/SnmpSubAgent.properties | cut -f2 -d':' | cut -f1 -d'/'`
		compare ${rcsIP} ${IPADDR}
		echo "/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties nCompass True/False"                
		ncctf=`grep NMS_NCOMPASS /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties | cut -f2 -d'='`
		if [ ${ncctf} = true ] ; then
			echo "nCompass NMS setting in /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties is correct"
		else
			echo "Please configure nCompass settings again"
		fi
		echo "/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties nCompass IP"
		nccIP=`grep NMS_IP /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties | cut -f2 -d':' | cut -f1 -d'/'`
		compare ${nccIP} ${NCOMPASSIP}
		echo "/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties nCompass Port"
		nccPort=`grep NMS_IP /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties | cut -f2 -d':' | cut -f1 -d'/'`
		compare ${nccPort} ${NCOMPASSPORT}
		echo "/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties RCS IP Address"
		rcsIP=`grep agent_URL /opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties | cut -f2 -d':' | cut -f1 -d'/'`
		compare ${rcsIP} ${IPADDR}
	fi
	
	echo "Permissions of uploaded content directory"
	ls -l /content/uploaded
	
	echo "Show IP Tables"
	iptables -L -v -t nat
	
	echo "Show CMS service run levels"
	chkconfig xportmanager --list
	chkconfig xporttomcat --list
	chkconfig rmserver --list
	chkconfig rcssnmpsubagent --list
	chkconfig RCSSchedulerService --list
	chkconfig cms --list
	chkconfig alerts --list
	chkconfig tomcat --list

	
elif [ ${CMSTYPE} -eq 2 ] ; then
	echo "DB Server"

	echo "Checking Oracle server status: "
        ORACLEPID=`ps aefx | grep [o]ra_pmon | awk '{print $1}'`
        if [ -z ${ORACLEPID} ];
        then
                echo "ORACLE SERVER IS DOWN"
        fi
        ORACLEPID=`ps aefx | grep [t]nslsnr | awk '{print $1}'`
        if [ -z ${ORACLEPID} ];
        then
                echo "ORACLE LISTENER SERVICE IS DOWN"
        fi

elif [ ${CMSTYPE} -eq 3 ] ; then
	if ls /usr/local/tstv/RMScheduler/config/licenseRMkey.lic > /dev/null ; then
                echo "An RM license file exists on the system"
        else
                echo "Can not locate RM license file on the system"
        fi

	echo "Checking Oracle server status: "
        ORACLEPID=`ps aefx | grep [o]ra_pmon | awk '{print $1}'`
        if [ -z ${ORACLEPID} ];
        then
                echo "ORACLE SERVER IS DOWN"
        fi
        ORACLEPID=`ps aefx | grep [t]nslsnr | awk '{print $1}'`
        if [ -z ${ORACLEPID} ];
        then
                echo "ORACLE LISTENER SERVICE IS DOWN"
        fi
	
	echo "Downstream configuration"
	if [ ${DOWNSTREAMTYPE} -eq 1 ] ; then 
		echo "Downstream type is AMS (version 4.X or lower)"
		PROVISIONING_DESTINATION=AMS
		pdest=`grep PROVISIONING_DESTINATION /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'='`
		compare ${pdest} ${PROVISIONING_DESTINATION}
		USE_FULL_CONTENT_URL_IN_ADI=false
		adiurl=`grep USE_FULL_CONTENT_URL_IN_ADI /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'='`
		compare ${USE_FULL_CONTENT_URL_IN_ADI} ${adiurl}
		CALCULATE_CHECKSUM=true
		checksum=`grep CALCULATE_CHECKSUM /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'='`
		compare ${CALCULATE_CHECKSUM} ${checksum}
		if grep ${DSIP} /etc/hosts > /dev/null; then
			echo "Downstream System IP is found in hosts file"
		else
			echo "Downstream System IP is not found in hosts file"
		fi
	
	elif [ ${DOWNSTREAMTYPE} -eq 2 ] ; then
		echo "Downstream type is AMS (version 5.X or higher)"
       		
		CALCULATE_CHECKSUM=true
		checksum=`grep CALCULATE_CHECKSUM /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'='`
		compare ${CALCULATE_CHECKSUM} ${checksum}
		if grep ${DSIP} /etc/hosts > /dev/null; then
			echo "Downstream System IP is found in hosts file"
		else
			echo "Downstream System IP is not found in hosts file"
		fi

	elif [ ${DOWNSTREAMTYPE} -eq 3 ] ; then
		echo "Downstream type is OpenStream (version 4.4 or lower)"
       		
		RTI_PROVISION_TO_OLD_OPENSTREAM=true
		oldos=`grep RTI_PROVISION_TO_OLD_OPENSTREAM /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'='`
		compare ${RTI_PROVISION_TO_OLD_OPENSTREAM} ${oldos}
		if grep ${DSIP} /etc/hosts > /dev/null; then
			echo "Downstream System IP is found in hosts file"
		else
			echo "Downstream System IP is not found in hosts file"
		fi

	elif [ ${DOWNSTREAMTYPE} -eq 4 ] ; then
		echo "Downstream type is OpenStream (version 4.5 or higher)"
       		
		if grep ${DSIP} /etc/hosts > /dev/null; then
			echo "Downstream System IP is found in hosts file"
		else
			echo "Downstream System IP is not found in hosts file"
		fi

	elif [ ${DOWNSTREAMTYPE} -eq 5 ] ; then
		if grep ${DSIP} /etc/hosts > /dev/null; then
			echo "Downstream System IP is found in hosts file"
		else
			echo "Downstream System IP is not found in hosts file"
		fi
	else
		echo "unknown Downstream system"
	fi	
	ftppathuser=`grep FTP_PROVISIONING_PATH= /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'=' | cut -f2 -d':' | cut -f2- -d'/' | cut -f2- -d'/'`
	compare ${ftppathuser} ${FTPNAME}
	ftppathpass=`grep FTP_PROVISIONING_PATH= /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'=' | cut -f3 -d':' | cut -f1 -d'@'`
	compare ${ftppathpass} ${FTPPASSWORD}
	ftpip=`grep FTP_PROVISIONING_PATH= /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'=' | cut -f3 -d':' | cut -f2 -d'@'`
	compare ${ftpip} ${IPADDR}
	rmweb=`grep RM_WEB_IP_ADDRESS= /usr/local/tstv/jboss/server/default/deploy/RMWeb.war/WEB-INF/classes/RMWebConfig.properties | cut -f2 -d'='`
	compare ${rmweb} ${IPADDR}

	for (( s=1; s<=${RTCCOUNT}; s++ )) ; do
		type=`grep RTCTYPE_${s} ${CONFIG_FILE} | cut -f2 -d'='`
		if [ ${type} -eq 1 ] ; then
			rtcip=`grep RTCIP_${z} ${CONFIG_FILE} | cut -f1 -d'_'`
			facname=`grep FACNAME_${z} ${CONFIG_FILE} | cut -f1 -d'_'`
			constore=`grep CONSTORE_${z} ${CONFIG_FILE} | cut -f1 -d'_'`
			ophost=`grep OPHOST_${z} ${CONFIG_FILE} | cut -f1 -d'_'`
			RTCIP=`grep ${rtcip}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
			FACName=`grep ${facname}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
			ConStore=`grep ${constore}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
			OPHost=`grep ${ophost}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
			if grep ${RTCIP} /etc/hosts > /dev/null; then
				echo "RTC IP is found in hosts file"
			else
				echo "RTC IP is not found in hosts file"
			fi
			if grep ${FACName} /etc/hosts > /dev/null; then
				echo "Factory name is found in hosts file"
			else
				echo "Factory name is not found in hosts file"
			fi
			if grep ${ConStore} /etc/hosts > /dev/null; then
				echo "Content Store is found in hosts file"
			else
				echo "Content Store is not found in hosts file"
			fi
			if grep ${OPHost} /etc/hosts > /dev/null; then
				echo "OPHost is found in hosts file"
			else
				echo "OPHost is not found in hosts file"
			fi

		elif [ ${type} -eq 2 ] ; then
			rtcip=`grep RTCIP_${z} ${CONFIG_FILE} | cut -f1 -d'_'`
                	facname=`grep FACNAME_${z} ${CONFIG_FILE} | cut -f1 -d'_'`
                	ophost=`grep OPHOST_${z} ${CONFIG_FILE} | cut -f1 -d'_'`
                	RTCIP=`grep ${rtcip}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
                	FACName=`grep ${facname}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
                	OPHost=`grep ${ophost}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
			if grep ${RTCIP} /etc/hosts > /dev/null; then
				echo "RTC IP is found in hosts file"
			else
				echo "RTC IP is not found in hosts file"
			fi
			if grep ${FACName} /etc/hosts > /dev/null; then
				echo "Factory name is found in hosts file"
			else
				echo "Factory name is not found in hosts file"
			fi
			if grep ${OPHost} /etc/hosts > /dev/null; then
				echo "OPHost is found in hosts file"
			else
				echo "OPHost is not found in hosts file"
			fi

		elif [ ${type} -eq 3 ] ; then
			l2vname=`grep L2VNAME_${z} ${CONFIG_FILE} | cut -f1 -d'_'`
                	l2vpassword=`grep L2VPASSWORD_${z} ${CONFIG_FILE} | cut -f1 -d'_'` 
			l2vname=`grep ${l2vname}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
			l2vpassword=`grep ${l2vpassword}_${z} ${CONFIG_FILE} | cut -f2 -d'='`
			name=`grep L2V_NAS_USERID= /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'='`		
			echo "L2V NAS Encrypted Username"
			compare ${l2vname} ${name}
			password=`grep L2V_NAS_PASSWORD= /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'='`		
			echo "L2V NAS Encrypted Password"
			compare ${l2vpassword} ${password}

		else
			echo "Capture Device not found in configuration file"
		fi
	done
	
	echo "Show IP Tables"
	iptables -L -v -t nat

	echo "Show RM service levels"
	chkconfig jboss --list
	chkconfig rmscheduler --list
	for (( i=1; i<=${RTCCOUNT}; i++ )) ; do
		type=`grep RTCTYPE_${i} ${CONFIG_FILE} | cut -f2 -d'='`
		if [ ${type} -eq 1 ] ; then
			j=1
		fi
	done
	if [ ${j} -eq 1 ] ; then
		chkconfig CORBAnameservice --list
		chkconfig CORBAnotificationservice --list
	fi

elif [ ${CMSTYPE} -eq 4 ] ; then
	echo "Ericsson RTC"
	
	echo "RTCFactory"
	rtcfactory=`grep contentStoreFactoryName /usr/local/tstv/rtc/config/RTCConfiguration.properties | cut -f2 -d'='`
	compare ${rtcfactory} ${FACTORY}
	echo "Content Store"
	contentstore=`grep contentStoreName /usr/local/tstv/rtc/config/RTCConfiguration.properties | cut -f2 -d'='`
	compare ${contentstore} ${CONTENTSTORE}
	echo "Extended Content Store"
	extcontentstore=`grep contentStoreName /usr/local/tstv/rtc/config/RTCConfiguration.properties | cut -f2 -d'='`
	compare ${extcontentstore} ${EXTCONTENTSTORE}
	echo "IIOPHOST"
	ophost=`grep IIOPHOST /usr/local/tstv/rtc/config/RTCConfiguration.properties | cut -f2 -d'='`
	compare ${ophost} ${IIOPHOST}
	echo "IIOPPORT"
	opport=`grep IIOPPORT /usr/local/tstv/rtc/config/RTCConfiguration.properties | cut -f2 -d'='`
	compare ${opport} ${IIOPPORT}
	echo "Allocated disk space"
	ads=`grep allocatedDiskSpace /usr/local/tstv/rtc/config/RTCConfiguration.properties | cut -f2 -d'='`
	compare ${ads} ${EXTCSDISKSPACE}
	echo "Threshhold Percentage"
	threshperc=`grep thresholdDiskUsagePercentage= /usr/local/tstv/rtc/config/RTCConfiguration.properties | cut -f2 -d'='`
	compare ${threshperc} ${THRESHPERCENT}
	echo "Threshhold Percentage After Cleanup"
	clnthreshperc=`grep thresholdDiskUsagePercentageAfterCleanup /usr/local/tstv/rtc/config/RTCConfiguration.properties | cut -f2 -d'='`
	compare ${clnthreshperc} ${CLEANTHRESHPERCENT}
	#ftppathuser=`grep FTP_PROVISIONING_PATH= /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'=' | cut -f2 -d':' | cut -f2- -d'/' | cut -f2- -d'/'`
	#compare ${ftppathuser} ${FTPNAME}
	#ftppathpass=`grep FTP_PROVISIONING_PATH= /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'=' | cut -f3 -d':' | cut -f1 -d'@'`
	#compare ${ftppathpass} ${FTPPASSWORD}
	#ftpip=`grep FTP_PROVISIONING_PATH= /usr/local/tstv/RMScheduler/config/rmScheduler.properties | cut -f2 -d'=' | cut -f3 -d':' | cut -f2 -d'@'`
	#compare ${ftpip} ${IPADDR}
	
	grep ${IPADDR} /etc/hosts
	grep ${FACTORY} /etc/hosts
	grep ${CONTENTSTORE} /etc/hosts
	grep ${IIOPHOST} /etc/hosts
	grep ${RMIP} /etc/hosts

else
	echo "unknown CMS type"
fi

exit 0
