#!/bin/bash
## Alex Rombro
DATE=`date +%d-%m-%y_%H%M`
ARCH_LOG=/var/log/CommonBackup/arch/commonbackup${DATE}.log
(
### using existing functionality ###
cb_bin_dir="$(cd `dirname $0` && pwd)"
cb_cfg_dir=`echo ${cb_bin_dir} | /usr/bin/awk -F'/' '{for (i = 2; i != NF; i++) printf("/%s",$i)}'`

CONFIG_FILE="${cb_cfg_dir}/conf/commonbackup.cfg"
CB_FUNCTIONS="${cb_bin_dir}/cb_functions.sh"

for f in ${CONFIG_FILE} ${CB_FUNCTIONS}
do
        if [[ -f ${f} ]];
        then
                . ${f}
        else
                echo " "
                echo "FATAL ERROR: ${f} does not exist"
                echo " "
                exit 1
        fi
done



# Determine free space on root partition
rs=`df -Ph / | tail -1 | awk '{print $5}' | cut -d'%' -f1`
if [[ $rs -ge 80 ]]; then
	adios "ERROR: More than 80% space on backup device or partition is used.  Backup will not run until more than 20% is available"
	exit 1
else
	/usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh
fi
) 2>&1 | tee -a ${ARCH_LOG}
exit 0

