/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.HashSet;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public abstract class NormalizeTitleMessageDispatcher
extends ContentMessageDispatcher {
    private static final Logger logger = Logger.getLogger(NormalizeTitleMessageDispatcher.class);
    protected static final String TITLE_ID = "titleId";
    protected static final String IS_VALID = "isValid";
    protected static final String TITLE_STATUS = "titleStatus";
    protected static final String ERROR_MESSAGE = "validationMessages";

    public NormalizeTitleMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)NormalizeTitleMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), NormalizeTitleMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    protected String getAllMessagesInOrder(ISavedTitle savedTitle) {
        HashSet allMsgSet = new HashSet();
        if (savedTitle.getValidationError() != null && savedTitle.getValidationError().getMessages() != null && savedTitle.getValidationError().getMessages().size() > 0) {
            logger.debug((Object)("Got validation error messages: " + savedTitle.getValidationError().getMessages()));
            allMsgSet.addAll(savedTitle.getValidationError().getMessages());
        } else if (savedTitle.getValidationMessages() != null && savedTitle.getValidationMessages().size() > 0) {
            logger.debug((Object)("Got validation messages: " + savedTitle.getValidationMessages()));
            allMsgSet.addAll(savedTitle.getValidationMessages());
        }
        StringBuilder errorMsgBuf = new StringBuilder();
        StringBuilder warningMsgBuf = new StringBuilder();
        StringBuilder infoMsgBuf = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (TitleValidationMessage validationMessage : allMsgSet) {
            if (TitleValidationMessage.Type.Error.equals((Object)validationMessage.getType())) {
                errorMsgBuf.append(validationMessage.getType() + ":" + validationMessage.getMessage()).append(lineSeparator);
                continue;
            }
            if (TitleValidationMessage.Type.Warning.equals((Object)validationMessage.getType())) {
                warningMsgBuf.append(validationMessage.getType() + ":" + validationMessage.getMessage()).append(lineSeparator);
                continue;
            }
            if (!TitleValidationMessage.Type.Info.equals((Object)validationMessage.getType())) continue;
            infoMsgBuf.append(validationMessage.getType() + ":" + validationMessage.getMessage()).append(lineSeparator);
        }
        return this.trimMessage(errorMsgBuf.toString() + warningMsgBuf.toString() + infoMsgBuf.toString());
    }

    protected String getErrorMessage(ISavedTitle savedTitle) {
        if (savedTitle.getValidationError() == null) {
            return "";
        }
        String message = savedTitle.getValidationError().getMessage();
        return this.trimMessage(message);
    }

    protected abstract String getEventNameForNormalization();

    protected abstract void validateTitle(Title var1);

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(NormalizeTitleMessageDispatcher this_, WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLE_ID});
        long titleId = Util.getLongValue((WorkflowMessage)request, (String)TITLE_ID);
        Title title = this_.getTitleForUpdate(titleId);
        this_.validateTitle(title);
        ITitleManager titleManager = this_.getTitleManager();
        try {
            title = titleManager.normalizeWithMetatadataEnhancement(title, this_.getEventNameForNormalization(), request.getKey().toString());
            ISavedTitle savedTitle = titleManager.save(title, this_.getActionSource(request));
            TitleStatus titleStatus = savedTitle.getTitle().getStatus();
            boolean valid = !TitleStatus.DRAFT.equals((Object)titleStatus);
            String statusName = titleStatus.name();
            String allMessage = this_.getAllMessagesInOrder(savedTitle);
            WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
            response.putValue(IS_VALID, Boolean.toString(valid));
            response.putValue(TITLE_STATUS, statusName);
            logger.debug((Object)("Ready to return validation message: " + allMessage));
            response.putValue(ERROR_MESSAGE, allMessage);
            return response;
        }
        catch (TitleValidationException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(NormalizeTitleMessageDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return NormalizeTitleMessageDispatcher.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = NormalizeTitleMessageDispatcher.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

