/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.Collection;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class ValidateTitleMessageDispatcher
extends ContentMessageDispatcher {
    private static final String TITLE_ID = "titleId";
    private static final String VALIDATION_RESULT = "isValid";
    private static final String VALIDATION_MESSAGES = "message";

    public ValidateTitleMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)ValidateTitleMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), ValidateTitleMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    protected String sortOutMessagesWithType(Collection<? extends TitleValidationMessage> messages) {
        StringBuilder errorMsgBuf = new StringBuilder();
        StringBuilder warningMsgBuf = new StringBuilder();
        StringBuilder infoMsgBuf = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (TitleValidationMessage titleValidationMessage : messages) {
            if (TitleValidationMessage.Type.Error.equals((Object)titleValidationMessage.getType())) {
                errorMsgBuf.append(titleValidationMessage.getType() + ":" + titleValidationMessage.getMessage()).append(lineSeparator);
                continue;
            }
            if (TitleValidationMessage.Type.Warning.equals((Object)titleValidationMessage.getType())) {
                warningMsgBuf.append(titleValidationMessage.getType() + ":" + titleValidationMessage.getMessage()).append(lineSeparator);
                continue;
            }
            if (!TitleValidationMessage.Type.Info.equals((Object)titleValidationMessage.getType())) continue;
            infoMsgBuf.append(titleValidationMessage.getType() + ":" + titleValidationMessage.getMessage()).append(lineSeparator);
        }
        return this.trimMessage(errorMsgBuf.toString() + warningMsgBuf.toString() + infoMsgBuf.toString());
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(ValidateTitleMessageDispatcher this_, WorkflowMessage request) {
        List messages;
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLE_ID});
        long titleId = Util.getLongValue((WorkflowMessage)request, (String)TITLE_ID);
        Title title = this_.getTitle(titleId);
        boolean isValid = true;
        try {
            messages = this_.getTitleManager().validate(title, false);
        }
        catch (TitleValidationException ex) {
            isValid = false;
            messages = ex.getMessages();
        }
        String validationMessages = this_.sortOutMessagesWithType(messages);
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        response.putValue(VALIDATION_RESULT, Boolean.toString(isValid));
        response.putValue(VALIDATION_MESSAGES, validationMessages);
        return response;
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(ValidateTitleMessageDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ValidateTitleMessageDispatcher.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = ValidateTitleMessageDispatcher.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

