/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.metadata;

import com.ericsson.cms.devices.content.metadata.AbstractAssetMessageDispatcher;
import com.ericsson.cms.devices.content.metadata.AssetUtils;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.List;

public abstract class AbstractUpdateAssetMessageDispatcher
extends AbstractAssetMessageDispatcher {
    public AbstractUpdateAssetMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected Title getTitle(WorkflowMessage request) {
        return this.getTitleForUpdate(this.getTitleId(request));
    }

    @Override
    protected WorkflowMessage performAssetOperation(WorkflowMessage request, Title title, Asset asset) {
        boolean changed = this.updateAsset(request, title, asset);
        ISavedTitle savedTitle = null;
        if (changed) {
            asset.setFieldTree(asset.getFieldTree());
            try {
                savedTitle = this.getTitleManager().save(title, this.getActionSource(request));
            }
            catch (TitleValidationException e) {
                String message = "Failed to save title after updating asset, error: " + e.getLocalizedMessage();
                throw new RuntimeException(message, e);
            }
        }
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        this.updateResponseParameters(response, request, title, asset, savedTitle);
        return response;
    }

    protected abstract boolean updateAsset(WorkflowMessage var1, Title var2, Asset var3);

    protected void updateResponseParameters(WorkflowMessage response, WorkflowMessage request, Title title, Asset asset, ISavedTitle savedTitle) {
    }

    protected boolean updateAssetField(Asset asset, String fieldXPath, String fieldValue) {
        boolean changed = false;
        Field firstField = AssetUtils.getFirstField(asset, fieldXPath);
        if (fieldValue != null) {
            String oldValue;
            String string = oldValue = firstField != null ? firstField.getValue() : null;
            if (!fieldValue.equals(oldValue)) {
                if (firstField != null) {
                    firstField.setValue(fieldValue);
                } else {
                    Field field = new Field(fieldXPath, fieldValue);
                    this.updateFieldIndices(field);
                    asset.addField(field);
                }
                changed = true;
            }
        } else if (firstField != null) {
            asset.getFields().remove(firstField);
            changed = true;
        }
        return changed;
    }

    private void updateFieldIndices(Field field) {
        String xpath = field.getTtvXPath();
        List indices = field.getIndices();
        int maxIndex = xpath.length() - 1;
        for (int index = 0; index <= maxIndex; ++index) {
            if (xpath.charAt(index) != '/' || index == maxIndex || xpath.charAt(index + 1) == '@') continue;
            indices.add(new Integer(1));
        }
    }
}

