/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.metadata;

import com.ericsson.cms.devices.content.metadata.AbstractAssetMessageDispatcher;
import com.ericsson.cms.devices.content.metadata.AssetUtils;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.ArrayList;
import java.util.List;

public class GetAssetDetailsMessageDispatcher
extends AbstractAssetMessageDispatcher {
    private static final String METADATA_RESPONSE_PARAMETERS = "MetadataResponseParameters";
    private static final String METADATA_RESPONSE_FIELD_NAME_SUFFIX = ".FieldName";
    private static final String ASSET_TYPE = "assetType";
    private static final String PARENT_ASSET_TYPE = "parentAssetType";
    private static final String PARENT_ASSET_ID = "parentAssetId";

    public GetAssetDetailsMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected Asset getAsset(WorkflowMessage request, Title title) {
        Asset asset = super.getAsset(request, title);
        if (asset instanceof File) {
            throw new RuntimeException("The asset[" + asset.getId() + "] in title[" + title.getId() + "] is a 'File' asset, cannot get asset details.");
        }
        return asset;
    }

    @Override
    protected WorkflowMessage performAssetOperation(WorkflowMessage request, Title title, Asset asset) {
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        response.putValue(ASSET_TYPE, asset.getType());
        Asset rootAsset = title.getAsset();
        Asset parentAsset = asset.equals(rootAsset) ? null : rootAsset.getAssetsParent(asset);
        String parentAssetId = parentAsset != null ? Long.toString(parentAsset.getId()) : "";
        String parentAssetType = parentAsset != null ? parentAsset.getAssetType() : "";
        response.putValue(PARENT_ASSET_ID, parentAssetId);
        response.putValue(PARENT_ASSET_TYPE, parentAssetType);
        List<String> parameters = this.getResponseParameters();
        for (String parameterName : parameters) {
            String fieldName = this.getParameterXPath(parameterName);
            String fieldXPath = this.getFieldXPath(fieldName);
            String fieldValue = AssetUtils.getFieldValue(asset, fieldXPath);
            response.putValue(parameterName, fieldValue);
        }
        return response;
    }

    private List<String> getResponseParameters() {
        String[] parameterNames;
        String parameterList;
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.getConfiguration() != null && (parameterList = this.getPropertyValue(METADATA_RESPONSE_PARAMETERS)) != null && (parameterNames = parameterList.split(",")) != null) {
            for (String parameterName : parameterNames) {
                if (parameterName == null || parameterName.trim().isEmpty()) continue;
                parameters.add(parameterName.trim());
            }
        }
        return parameters;
    }

    private String getParameterXPath(String parameterName) {
        String xpathParameterName = parameterName + METADATA_RESPONSE_FIELD_NAME_SUFFIX;
        String xpath = null;
        if (this.getConfiguration() != null && (xpath = this.getPropertyValue(xpathParameterName)) != null) {
            xpath = xpath.trim();
        }
        if (xpath == null || xpath.isEmpty()) {
            throw new RuntimeException("Response parameter[" + parameterName + "] does not have field xpath configured, set value for dispatcher property: " + xpathParameterName);
        }
        return xpath;
    }
}

