/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.metadata;

import com.ericsson.cms.devices.content.metadata.AbstractAssetMessageDispatcher;
import com.ericsson.cms.devices.content.metadata.AssetUtils;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;

public class GetAssetMetadataCustomFieldValueMessageDispatcher
extends AbstractAssetMessageDispatcher {
    private static final String FIELD = "field";
    private static final String FIELD_VALUE = "value";

    public GetAssetMetadataCustomFieldValueMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected void validateRequiredParameters(WorkflowMessage request) {
        super.validateRequiredParameters(request);
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{FIELD});
    }

    @Override
    protected WorkflowMessage performAssetOperation(WorkflowMessage request, Title title, Asset asset) {
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        String customFieldName = Util.getStringValueTrimmed((WorkflowMessage)request, (String)FIELD);
        String customFieldXPath = this.getCustomFieldXPath(customFieldName);
        String value = AssetUtils.getFieldValue(asset, customFieldXPath);
        response.putValue(FIELD_VALUE, value);
        return response;
    }
}

