/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.metadata;

import com.ericsson.cms.devices.content.metadata.AbstractAssetMessageDispatcher;
import com.ericsson.cms.devices.content.metadata.AssetUtils;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;

public class GetAssetMetadataCustomFieldValuesMessageDispatcher
extends AbstractAssetMessageDispatcher {
    protected static final String FIELD_PREFIX = "field";
    protected static final String FIELD_VALUE_PREFIX = "value";

    public GetAssetMetadataCustomFieldValuesMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected void validateRequiredParameters(WorkflowMessage request) {
        super.validateRequiredParameters(request);
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{this.getIndexedParameterName(FIELD_PREFIX, 1)});
    }

    @Override
    protected WorkflowMessage performAssetOperation(WorkflowMessage request, Title title, Asset asset) {
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        for (int index = 1; index <= 10; ++index) {
            String fieldParameter = this.getIndexedParameterName(FIELD_PREFIX, index);
            String fieldValueParameter = this.getIndexedParameterName(FIELD_VALUE_PREFIX, index);
            String name = Util.getStringValueTrimmed((WorkflowMessage)request, (String)fieldParameter);
            String value = name != null ? AssetUtils.getFieldValue(asset, this.getCustomFieldXPath(name)) : "";
            response.putValue(fieldValueParameter, value);
        }
        return response;
    }
}

