/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="CM_AUDIT", uniqueConstraints={@UniqueConstraint(columnNames={"AUDIT_ID"})})
public class Audit
implements Serializable {
    private static final long serialVersionUID = -657543708650348054L;
    private Long idAudit;
    private String auditMessage;
    private String userName;
    private Long auditType;
    private Date createDate;
    private Long auditAction;

    public Audit() {
    }

    public Audit(String auditMessage, String userName, Long auditAction, Long auditType, Date createDate) {
        this.auditMessage = auditMessage;
        this.userName = userName;
        this.auditAction = auditAction;
        this.auditType = auditType;
        this.createDate = createDate;
    }

    public Audit(String auditMessage, String userName, Long auditType, Date createDate) {
        this.auditMessage = auditMessage;
        this.userName = userName;
        this.auditType = auditType;
        this.createDate = createDate;
    }

    @Id
    @Column(name="AUDIT_ID", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="AuditID Sequence Generator", sequenceName="CM_AUDIT_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AuditID Sequence Generator")
    public Long getIdAudit() {
        return this.idAudit;
    }

    public void setIdAudit(Long idAudit) {
        this.idAudit = idAudit;
    }

    @Column(name="AUDIT_MESSAGE", unique=false, length=2000)
    public String getAuditMessage() {
        return this.auditMessage;
    }

    public void setAuditMessage(String auditMessage) {
        this.auditMessage = auditMessage;
    }

    @Column(name="USER_NAME", unique=false, length=100)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name="AUDIT_TYPE", unique=false)
    public Long getAuditType() {
        return this.auditType;
    }

    public void setAuditType(Long auditType) {
        this.auditType = auditType;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATEDATE", nullable=false)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name="AUDIT_ACTION", unique=false)
    public Long getAuditAction() {
        return this.auditAction;
    }

    public void setAuditAction(Long auditAction) {
        this.auditAction = auditAction;
    }

    public String toString() {
        return "UserName : " + this.userName + " - " + "AuditType: " + this.auditType.toString() + " - " + "AuditAction: " + this.auditAction.toString() + " - " + "CreateDate; " + this.createDate.toString() + " - " + "AuditMessage: " + this.auditMessage;
    }
}

