/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.ContractContacts;
import com.ericsson.ejb.ContractDocuments;
import com.ericsson.ejb.ContractType;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.Deal;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CM_CONTRACT", uniqueConstraints={@UniqueConstraint(columnNames={"NAME"})})
public class Contract
implements Serializable {
    private static final long serialVersionUID = 2197570341167339282L;
    private Long idContract;
    private CopyrightHolder copyrightHolder;
    private ContractType contractType;
    private String name;
    private Boolean active;
    private Date creationDate;
    private Date effectiveDate;
    private Date expiryDate;
    private Long dealExpiryReminder;
    private Set<ContractContacts> contractContacts = new HashSet<ContractContacts>(0);
    private Set<CustomLicFieldValue> contractCustomLicFieldValues = new HashSet<CustomLicFieldValue>(0);
    private Set<ContractDocuments> contractDocuments = new HashSet<ContractDocuments>(0);
    private Set<Deal> deals = new HashSet<Deal>(0);
    private String externalId;

    public Contract() {
    }

    public Contract(CopyrightHolder copyrightHolder, ContractType contractType, String name, Boolean active, Date creationDate, Date effectiveDate, Date expiryDate) {
        this.copyrightHolder = copyrightHolder;
        this.contractType = contractType;
        this.name = name;
        this.active = active;
        this.creationDate = creationDate;
        this.effectiveDate = effectiveDate;
        this.expiryDate = expiryDate;
    }

    public Contract(CopyrightHolder copyrightHolder, ContractType contractType, String name, Boolean active, Date creationDate, Date effectiveDate, Date expiryDate, Long dealExpiryReminder, Set<ContractContacts> contractContacts, Set<CustomLicFieldValue> customLicFieldValues, Set<ContractDocuments> contractDocuments, Set<Deal> deals) {
        this.copyrightHolder = copyrightHolder;
        this.contractType = contractType;
        this.name = name;
        this.active = active;
        this.creationDate = creationDate;
        this.effectiveDate = effectiveDate;
        this.expiryDate = expiryDate;
        this.dealExpiryReminder = dealExpiryReminder;
        this.contractContacts = contractContacts;
        this.contractCustomLicFieldValues = customLicFieldValues;
        this.contractDocuments = contractDocuments;
        this.deals = deals;
    }

    @Id
    @Column(name="ID_CONTRACT", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="ContractID Sequence Generator", sequenceName="CM_CONTRACT_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ContractID Sequence Generator")
    public Long getIdContract() {
        return this.idContract;
    }

    public void setIdContract(Long idContract) {
        this.idContract = idContract;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COPYRIGHTHOLDER", nullable=false)
    public CopyrightHolder getCopyrightHolder() {
        return this.copyrightHolder;
    }

    public void setCopyrightHolder(CopyrightHolder copyrightHolder) {
        this.copyrightHolder = copyrightHolder;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TYPE", nullable=false)
    public ContractType getContractType() {
        return this.contractType;
    }

    public void setContractType(ContractType contractType) {
        this.contractType = contractType;
    }

    @Column(name="NAME", unique=true, nullable=false, length=50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Type(type="yes_no")
    @Column(name="ACTIVE", nullable=false, length=1)
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CREATION_DATE", nullable=false)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EFFECTIVE_DATE", nullable=false)
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EXPIRY_DATE", nullable=false)
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Column(name="DEAL_EXPIRY_REMINDER", precision=22, scale=0)
    public Long getDealExpiryReminder() {
        return this.dealExpiryReminder;
    }

    public void setDealExpiryReminder(Long dealExpiryReminder) {
        this.dealExpiryReminder = dealExpiryReminder;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="contract", cascade={CascadeType.ALL})
    public Set<ContractContacts> getContractContacts() {
        return this.contractContacts;
    }

    public void setContractContacts(Set<ContractContacts> contractContacts) {
        this.contractContacts = contractContacts;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_CONTRACT")
    public Set<CustomLicFieldValue> getContractCustomLicFieldValues() {
        return this.contractCustomLicFieldValues;
    }

    public void setContractCustomLicFieldValues(Set<CustomLicFieldValue> customLicFieldValues) {
        this.contractCustomLicFieldValues = customLicFieldValues;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="contract", cascade={CascadeType.ALL})
    public Set<ContractDocuments> getContractDocuments() {
        return this.contractDocuments;
    }

    public void setContractDocuments(Set<ContractDocuments> contractDocuments) {
        this.contractDocuments = contractDocuments;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="contract", cascade={CascadeType.ALL})
    public Set<Deal> getDeals() {
        return this.deals;
    }

    public void setDeals(Set<Deal> deals) {
        this.deals = deals;
    }

    @Column(name="EXTERNAL_ID", unique=true, nullable=true, length=100)
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }
}

